/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.junit5;

import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.togglz.core.context.FeatureContext;
import org.togglz.core.manager.FeatureManager;
import org.togglz.testing.TestFeatureManager;
import org.togglz.testing.TestFeatureManagerProvider;

abstract class FeatureManagerExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private TestFeatureManager featureManager = null;

    FeatureManagerExtension() {
    }

    abstract TestFeatureManager createTestFeatureManager(ExtensionContext var1);

    public void beforeEach(ExtensionContext context) {
        this.featureManager = this.createTestFeatureManager(context);
        TestFeatureManagerProvider.setFeatureManager((FeatureManager)this.featureManager);
        FeatureContext.clearCache();
    }

    public void afterEach(ExtensionContext context) {
        TestFeatureManagerProvider.setFeatureManager(null);
        FeatureContext.clearCache();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType().isAssignableFrom(TestFeatureManager.class);
    }

    public TestFeatureManager resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.featureManager;
    }
}

