/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.redis;

import java.util.Map;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.Pool;

public class RedisStateRepository
implements StateRepository {
    public static final String ENABLED_FIELD = "enabled";
    public static final String STRATEGY_FIELD = "strategy";
    public static final String PARAMETER_PREFIX = "parameter:";
    public static final int PARAMETER_PREFIX_LENGTH = "parameter:".length();
    protected final Pool<Jedis> jedisPool;
    protected final String keyPrefix;

    private RedisStateRepository(Builder builder) {
        this.keyPrefix = builder.keyPrefix;
        this.jedisPool = builder.jedisPool != null ? builder.jedisPool : new JedisPool();
    }

    public FeatureState getFeatureState(Feature feature) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Map redisMap = jedis.hgetAll(this.keyPrefix + feature.name());
            if (redisMap == null || redisMap.size() == 0) {
                FeatureState featureState = null;
                return featureState;
            }
            FeatureState featureState = new FeatureState(feature);
            featureState.setEnabled(Boolean.parseBoolean((String)redisMap.get(ENABLED_FIELD)));
            featureState.setStrategyId((String)redisMap.get(STRATEGY_FIELD));
            for (Map.Entry entry : redisMap.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith(PARAMETER_PREFIX)) continue;
                featureState.setParameter(key.substring(PARAMETER_PREFIX_LENGTH), (String)entry.getValue());
            }
            FeatureState featureState2 = featureState;
            return featureState2;
        }
    }

    public void setFeatureState(FeatureState featureState) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Map parameterMap;
            String featureKey = this.keyPrefix + featureState.getFeature().name();
            jedis.hset(featureKey, ENABLED_FIELD, Boolean.toString(featureState.isEnabled()));
            String strategyId = featureState.getStrategyId();
            if (strategyId != null) {
                jedis.hset(featureKey, STRATEGY_FIELD, strategyId);
            }
            if ((parameterMap = featureState.getParameterMap()) != null) {
                for (Map.Entry entry : parameterMap.entrySet()) {
                    jedis.hset(featureKey, PARAMETER_PREFIX + (String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    public static class Builder {
        private Pool<Jedis> jedisPool = null;
        private String keyPrefix = "togglz:";

        public Builder jedisPool(Pool<Jedis> jedisPool) {
            this.jedisPool = jedisPool;
            return this;
        }

        public Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public RedisStateRepository build() {
            return new RedisStateRepository(this);
        }
    }
}

