/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.servlet.activation;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.togglz.core.activation.Parameter;
import org.togglz.core.activation.ParameterBuilder;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.util.Strings;
import org.togglz.servlet.util.HttpServletRequestHolder;

public class ClientIpActivationStrategy
implements ActivationStrategy {
    public static final String ID = "client-ip";
    public static final String PARAM_IPS = "ips";

    public String getId() {
        return ID;
    }

    public String getName() {
        return "IP address (client)";
    }

    public boolean isActive(FeatureState featureState, FeatureUser user) {
        HttpServletRequest request = HttpServletRequestHolder.get();
        if (request != null) {
            String allowedIpsParam = featureState.getParameter(PARAM_IPS);
            List allowsIps = Strings.splitAndTrim((String)allowedIpsParam, (String)"[\\s,]+");
            return allowsIps.contains(request.getRemoteAddr());
        }
        return false;
    }

    public Parameter[] getParameters() {
        return new Parameter[]{ParameterBuilder.create((String)PARAM_IPS).label("Client IPs").description("A comma-separated list of client IPs for which the feature should be active.")};
    }
}

