/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.servlet.activation;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.togglz.core.activation.Parameter;
import org.togglz.core.activation.ParameterBuilder;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.util.Strings;
import org.togglz.servlet.util.HttpServletRequestHolder;

public class ServerNameActivationStrategy
implements ActivationStrategy {
    static final String ID = "servername";
    static final String PARAM_SERVER_NAMES = "servernames";

    public String getId() {
        return ID;
    }

    public String getName() {
        return "Server names (vhosts)";
    }

    public boolean isActive(FeatureState featureState, FeatureUser user) {
        HttpServletRequest request = this.getServletRequest();
        if (request != null) {
            String allowedServerNamesParam = featureState.getParameter(PARAM_SERVER_NAMES);
            List allowedServerNames = Strings.splitAndTrim((String)allowedServerNamesParam, (String)"[\\s,]+");
            return allowedServerNames.contains(request.getServerName());
        }
        return false;
    }

    HttpServletRequest getServletRequest() {
        return HttpServletRequestHolder.get();
    }

    public Parameter[] getParameters() {
        return new Parameter[]{ParameterBuilder.create((String)PARAM_SERVER_NAMES).label("Server names").description("A comma-separated list of server names (virtual hosts) used in request for which the feature should be active.")};
    }
}

