/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.servlet;

import jakarta.servlet.ServletContext;

class TogglzFilterConfig {
    private final ServletContext servletContext;

    public TogglzFilterConfig(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Boolean isPerformBootstrap() {
        String managerProvided = this.servletContext.getInitParameter("org.togglz.FEATURE_MANAGER_PROVIDED");
        if (managerProvided != null) {
            return !TogglzFilterConfig.toBool(managerProvided);
        }
        String localManager = this.servletContext.getInitParameter("org.togglz.LOCAL_FEATURE_MANAGER");
        if (localManager != null) {
            return TogglzFilterConfig.toBool(localManager);
        }
        return null;
    }

    private static boolean toBool(String value) {
        if (value != null && "true".equalsIgnoreCase(value.trim())) {
            return true;
        }
        if (value != null && "false".equalsIgnoreCase(value.trim())) {
            return false;
        }
        throw new IllegalArgumentException("Not a valid boolean value: " + value);
    }
}

