/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.servlet.user;

import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.user.SimpleFeatureUser;
import org.togglz.core.user.UserProvider;
import org.togglz.servlet.util.HttpServletRequestHolder;

public class ServletUserProvider
implements UserProvider {
    private final String featureAdminRole;

    public ServletUserProvider(String featureAdminRole) {
        this.featureAdminRole = featureAdminRole;
    }

    public FeatureUser getCurrentUser() {
        HttpServletRequest request = HttpServletRequestHolder.get();
        if (request == null) {
            throw new IllegalStateException("Could not get request from HttpServletRequestHolder. Did you configure the TogglzFilter correctly?");
        }
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            boolean featureAdmin = request.isUserInRole(this.featureAdminRole);
            return new SimpleFeatureUser(principal.getName(), featureAdmin);
        }
        return null;
    }
}

