/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.actuate.autoconfigure;

import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementContextAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.togglz.console.TogglzConsoleServlet;
import org.togglz.spring.boot.actuate.autoconfigure.TogglzAutoConfiguration;
import org.togglz.spring.boot.actuate.autoconfigure.TogglzConsoleBaseConfiguration;
import org.togglz.spring.boot.actuate.autoconfigure.TogglzProperties;

@ManagementContextConfiguration
@ConditionalOnClass(value={Endpoint.class})
@ConditionalOnProperty(prefix="togglz", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={TogglzProperties.class})
@AutoConfigureAfter(value={TogglzAutoConfiguration.class, ManagementContextAutoConfiguration.class})
public class TogglzManagementContextConfiguration {

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={TogglzConsoleServlet.class})
    @ConditionalOnBean(value={ManagementServerProperties.class})
    @Conditional(value={TogglzConsoleBaseConfiguration.OnConsoleAndUseManagementPort.class})
    protected static class TogglzConsoleConfiguration
    extends TogglzConsoleBaseConfiguration {
        private final ManagementServerProperties managementServerProperties;

        protected TogglzConsoleConfiguration(TogglzProperties properties, ManagementServerProperties managementServerProperties) {
            super(properties);
            this.managementServerProperties = managementServerProperties;
        }

        @Override
        protected String getContextPath() {
            return this.managementServerProperties.getBasePath();
        }
    }
}

