/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.autoconfigure;

import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.togglz.console.TogglzConsoleServlet;
import org.togglz.spring.boot.autoconfigure.TogglzProperties;

@ManagementContextConfiguration
@ConditionalOnBean(value={ManagementServerProperties.class})
@ConditionalOnProperty(prefix="togglz", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={TogglzProperties.class})
public class TogglzManagementContextConfiguration {

    static class OnConsoleAndUseManagementPort
    extends AllNestedConditions {
        OnConsoleAndUseManagementPort() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="togglz.console", name={"use-management-port"}, havingValue="true", matchIfMissing=true)
        static class OnNotUseManagementPort {
            OnNotUseManagementPort() {
            }
        }

        @ConditionalOnProperty(prefix="togglz.console", name={"enabled"}, matchIfMissing=true)
        static class OnConsole {
            OnConsole() {
            }
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={TogglzConsoleServlet.class})
    @Conditional(value={OnConsoleAndUseManagementPort.class})
    protected static class TogglzConsoleConfiguration {
        @Autowired
        private TogglzProperties properties;
        @Autowired
        private ManagementServerProperties managementServerProperties;

        protected TogglzConsoleConfiguration() {
        }

        @Bean
        public ServletRegistrationBean togglzConsole() {
            String path = this.managementServerProperties.getContextPath() + this.properties.getConsole().getPath();
            String urlMapping = path.endsWith("/") ? path + "*" : path + "/*";
            TogglzConsoleServlet servlet = new TogglzConsoleServlet();
            servlet.setSecured(this.properties.getConsole().isSecured());
            return new ServletRegistrationBean((Servlet)servlet, new String[]{urlMapping});
        }
    }
}

