/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.autoconfigure;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.togglz.core.Feature;

@ConfigurationProperties(prefix="togglz", ignoreUnknownFields=true)
public class TogglzProperties {
    private boolean enabled = true;
    private Class<? extends Feature>[] featureEnums;
    private String featureManagerName;
    private Map<String, String> features;
    private String featuresFile;
    private Integer featuresFileMinCheckInterval;
    private Cache cache = new Cache();
    @Valid
    private Console console = new Console();
    private Endpoint endpoint = new Endpoint();
    private Web web = new Web();

    public boolean isEnabled() {
        return this.enabled;
    }

    public Class<? extends Feature>[] getFeatureEnums() {
        return this.featureEnums;
    }

    public void setFeatureEnums(Class<? extends Feature>[] featureEnums) {
        this.featureEnums = featureEnums;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getFeatureManagerName() {
        return this.featureManagerName;
    }

    public void setFeatureManagerName(String featureManagerName) {
        this.featureManagerName = featureManagerName;
    }

    public Map<String, String> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, String> features) {
        this.features = features;
    }

    public String getFeaturesFile() {
        return this.featuresFile;
    }

    public void setFeaturesFile(String featuresFile) {
        this.featuresFile = featuresFile;
    }

    public Integer getFeaturesFileMinCheckInterval() {
        return this.featuresFileMinCheckInterval;
    }

    public void setFeaturesFileMinCheckInterval(Integer featuresFileMinCheckInterval) {
        this.featuresFileMinCheckInterval = featuresFileMinCheckInterval;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Console getConsole() {
        return this.console;
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public static class Endpoint {
        private String id = "togglz";
        private boolean enabled = true;
        private boolean sensitive = true;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isSensitive() {
            return this.sensitive;
        }

        public void setSensitive(boolean sensitive) {
            this.sensitive = sensitive;
        }
    }

    public static class Web {
        private boolean registerFeatureInterceptor = false;

        public boolean isRegisterFeatureInterceptor() {
            return this.registerFeatureInterceptor;
        }

        public void setRegisterFeatureInterceptor(boolean registerFeatureInterceptor) {
            this.registerFeatureInterceptor = registerFeatureInterceptor;
        }
    }

    public static class Console {
        private boolean enabled = true;
        @NotNull
        @Pattern(regexp="/[^?#]*", message="Path must start with /")
        private String path = "/togglz-console";
        private String featureAdminAuthority;
        private boolean secured = true;
        private boolean useManagementPort = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getFeatureAdminAuthority() {
            return this.featureAdminAuthority;
        }

        public void setFeatureAdminAuthority(String featureAdminAuthority) {
            this.featureAdminAuthority = featureAdminAuthority;
        }

        public boolean isSecured() {
            return this.secured;
        }

        public void setSecured(boolean secured) {
            this.secured = secured;
        }

        public boolean isUseManagementPort() {
            return this.useManagementPort;
        }

        public void setUseManagementPort(boolean useManagementPort) {
            this.useManagementPort = useManagementPort;
        }
    }

    public static class Cache {
        private boolean enabled = false;
        private long timeToLive = 0L;
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public long getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(long timeToLive) {
            this.timeToLive = timeToLive;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }
    }
}

