/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.actuate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.util.Assert;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.repository.FeatureState;
import org.togglz.spring.boot.actuate.autoconfigure.TogglzFeature;

@Endpoint(id="togglz")
public class TogglzEndpoint {
    private final FeatureManager featureManager;

    public TogglzEndpoint(FeatureManager featureManager) {
        Assert.notNull((Object)featureManager, (String)"FeatureManager must not be null");
        this.featureManager = featureManager;
    }

    @ReadOperation
    public List<TogglzFeature> getAllFeatures() {
        ArrayList<TogglzFeature> features = new ArrayList<TogglzFeature>();
        for (Feature feature : this.featureManager.getFeatures()) {
            FeatureState featureState = this.featureManager.getFeatureState(feature);
            features.add(new TogglzFeature(feature, featureState));
        }
        Collections.sort(features);
        return features;
    }

    @WriteOperation
    public TogglzFeature setFeatureState(@Selector String name, boolean enabled) {
        Feature feature = this.featureManager.getFeatures().stream().filter(f -> f.name().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find feature with name " + name));
        FeatureState featureState = this.changeFeatureStatus(feature, enabled);
        return new TogglzFeature(feature, featureState);
    }

    private FeatureState changeFeatureStatus(Feature feature, boolean enabled) {
        FeatureState featureState = this.featureManager.getFeatureState(feature);
        featureState.setEnabled(enabled);
        this.featureManager.setFeatureState(featureState);
        return featureState;
    }
}

