/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.actuate.autoconfigure;

import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.togglz.core.manager.FeatureManager;
import org.togglz.spring.boot.actuate.TogglzEndpoint;
import org.togglz.spring.boot.actuate.TogglzEndpointWebExtension;
import org.togglz.spring.boot.actuate.autoconfigure.TogglzAutoConfiguration;
import org.togglz.spring.listener.TogglzApplicationContextBinderApplicationListener;

@Configuration
@ConditionalOnClass(value={Endpoint.class})
@AutoConfigureAfter(value={TogglzAutoConfiguration.class})
public class TogglzEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={TogglzApplicationContextBinderApplicationListener.class})
    TogglzApplicationContextBinderApplicationListener.ContextRefreshedEventFilter contextRefreshedEventFilter() {
        return contextRefreshedEvent -> {
            ApplicationContext applicationContext = contextRefreshedEvent.getApplicationContext();
            if (applicationContext instanceof ConfigurableWebServerApplicationContext) {
                return ((ConfigurableWebServerApplicationContext)applicationContext).getServerNamespace() == null;
            }
            return false;
        };
    }

    @Bean
    @ConditionalOnBean(value={FeatureManager.class})
    @ConditionalOnMissingBean
    public TogglzEndpoint togglzEndpoint(FeatureManager featureManager) {
        return new TogglzEndpoint(featureManager);
    }

    @Bean
    @ConditionalOnBean(value={TogglzEndpoint.class})
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint(exposure={EndpointExposure.WEB, EndpointExposure.CLOUD_FOUNDRY})
    public TogglzEndpointWebExtension togglzEndpointWebExtension(FeatureManager featureManager) {
        return new TogglzEndpointWebExtension(featureManager);
    }
}

