/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.domain;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tohu.domain.BooleanDomainModelAdapter;
import org.tohu.domain.CharDomainModelAdapter;
import org.tohu.domain.DecimalDomainModelAdapter;
import org.tohu.domain.DomainModelAdapter;
import org.tohu.domain.ListDomainModelAdapter;
import org.tohu.domain.NumberDomainModelAdapter;
import org.tohu.domain.StraightThroughDomainModelAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainModelSupport {
    private static Map<String, DomainModelAdapter> adapters = new HashMap<String, DomainModelAdapter>();

    private static String createAdapterKey(Class<?> clazz) {
        String className = List.class.isAssignableFrom(clazz) ? "java.util.List" : clazz.getName();
        return className;
    }

    public static void registerAdapter(DomainModelAdapter adapter) {
        for (Class<?> clazz : adapter.getSupportedClasses()) {
            adapters.put(DomainModelSupport.createAdapterKey(clazz), adapter);
        }
    }

    public static Object answerToObject(String answerType, Object answer, Class<?> clazz) {
        DomainModelAdapter adapter = adapters.get(DomainModelSupport.createAdapterKey(clazz));
        if (adapter == null) {
            throw new UnsupportedOperationException("Unable to convert from answer type " + answerType + " to Java class " + clazz.getName());
        }
        return adapter.answerToObject(answer, clazz);
    }

    public static Object objectToAnswer(Object object, String answerType) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        DomainModelAdapter adapter = adapters.get(DomainModelSupport.createAdapterKey(clazz));
        if (adapter == null) {
            throw new UnsupportedOperationException("Unable to convert from Java class " + clazz.getName() + " to answer type " + answerType);
        }
        return adapter.objectToAnswer(object);
    }

    public static String classToAnswerType(Class<?> clazz) {
        DomainModelAdapter adapter = adapters.get(DomainModelSupport.createAdapterKey(clazz));
        if (adapter == null) {
            throw new UnsupportedOperationException("Unable to support Java class " + clazz);
        }
        return adapter.getAnswerType();
    }

    static {
        DomainModelSupport.registerAdapter(new StraightThroughDomainModelAdapter("text", String.class));
        DomainModelSupport.registerAdapter(new CharDomainModelAdapter());
        DomainModelSupport.registerAdapter(new NumberDomainModelAdapter());
        DomainModelSupport.registerAdapter(new DecimalDomainModelAdapter());
        DomainModelSupport.registerAdapter(new BooleanDomainModelAdapter());
        DomainModelSupport.registerAdapter(new StraightThroughDomainModelAdapter("date", Date.class));
        DomainModelSupport.registerAdapter(new ListDomainModelAdapter());
    }
}

