/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.server;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionServerHelper {
    private static final String KNOWLEDGE_SESSION = "knowledge.session";
    private static final String AGENT_CONFIG_DIRECTORY = "agent-config-directory";
    private HttpSession session;

    public ExecutionServerHelper(HttpSession session) {
        ResourceType.addResourceTypeToRegistry((String)"CHANGE_SET", (String)"Change Set", (String)"src/main/resources", (String)"xcs", (String[])new String[]{"xml"});
        this.session = session;
    }

    public StatefulKnowledgeSession getKnowledgeSession() {
        return (StatefulKnowledgeSession)this.session.getAttribute(KNOWLEDGE_SESSION);
    }

    public void removeKnowledgeSession() {
        StatefulKnowledgeSession knowledgeSession = this.getKnowledgeSession();
        if (knowledgeSession != null) {
            knowledgeSession.dispose();
            this.session.removeAttribute(KNOWLEDGE_SESSION);
        }
    }

    public StatefulKnowledgeSession newKnowledgeSession(String agentName) {
        this.removeKnowledgeSession();
        String agentFile = "/" + agentName + ".xml";
        String agentConfigDir = this.session.getServletContext().getInitParameter(AGENT_CONFIG_DIRECTORY);
        return this.newKnowledgeSession(Collections.singletonList(agentConfigDir + agentFile));
    }

    public StatefulKnowledgeSession newKnowledgeSession(List<String> fileNames) {
        KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String fileName : fileNames) {
            Resource resource = fileName.startsWith("classpath:") ? ResourceFactory.newClassPathResource((String)fileName.replace("classpath:", "")) : ResourceFactory.newUrlResource((String)fileName);
            knowledgeBuilder.add(resource, ResourceType.determineResourceType((String)fileName));
        }
        if (knowledgeBuilder.hasErrors()) {
            throw new RuntimeException("Error in rules: " + knowledgeBuilder.getErrors());
        }
        StatefulKnowledgeSession knowledgeSession = knowledgeBuilder.newKnowledgeBase().newStatefulKnowledgeSession();
        this.session.setAttribute(KNOWLEDGE_SESSION, (Object)knowledgeSession);
        return knowledgeSession;
    }
}

