/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.server;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.drools.core.runtime.help.impl.XStreamXML;
import org.kie.api.command.Command;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.tohu.server.ExecutionServerHelper;

public class TohuExecutionServer
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String AGENT = "agent";
    private XStream xstream = XStreamXML.newXStreamMarshaller((XStream)new XStream());

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        ExecutionServerHelper helper = new ExecutionServerHelper(session);
        StatefulKnowledgeSession knowledgeSession = helper.getKnowledgeSession();
        if (knowledgeSession == null) {
            String agentName = request.getParameter(AGENT);
            knowledgeSession = helper.newKnowledgeSession(agentName);
        }
        Command command = (Command)this.xstream.fromXML((InputStream)request.getInputStream());
        Object results = knowledgeSession.execute(command);
        String xml = this.xstream.toXML(results);
        response.setContentType("text/xml");
        PrintWriter writer = response.getWriter();
        writer.write(xml);
        writer.close();
    }
}

