/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.toilelibre.libe.curl.Arguments;

final class ReadArguments {
    ReadArguments() {
    }

    static CommandLine getCommandLineFromRequest(String requestCommand) {
        CommandLine commandLine;
        DefaultParser parser = new DefaultParser();
        String requestCommandWithoutBasename = requestCommand.replaceAll("^[ ]*curl[ ]*", " ") + " ";
        String[] args = ReadArguments.getArgsFromCommand(requestCommandWithoutBasename);
        try {
            commandLine = parser.parse(Arguments.OPTIONS, args);
        }
        catch (ParseException e) {
            new HelpFormatter().printHelp("curl", Arguments.OPTIONS);
            throw new RuntimeException(e);
        }
        return commandLine;
    }

    private static String[] getArgsFromCommand(String requestCommandWithoutBasename) {
        String requestCommandInput = requestCommandWithoutBasename.replaceAll("\\s+-([a-zA-Z0-9])", " -$1 ");
        Matcher matcher = Pattern.compile("([^'\"][^ ]*|(?:\"(?:[^\"]|\\\\\")+\")|(?:'(?:[^']|[^ ]+')+'))\\s+").matcher(requestCommandInput);
        ArrayList<String> args = new ArrayList<String>();
        while (matcher.find()) {
            args.add(ReadArguments.removeSlashes(matcher.group(1).trim()));
        }
        return args.toArray(new String[args.size()]);
    }

    private static String removeSlashes(String arg) {
        if (arg.charAt(0) == '\"') {
            return arg.substring(1, arg.length() - 1).replaceAll("\\\"", "\"");
        }
        if (arg.charAt(0) == '\'') {
            return arg.substring(1, arg.length() - 1).replaceAll("\\'", "'");
        }
        return arg;
    }
}

