/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicHeader;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.Curl;
import org.toilelibre.libe.curl.IOUtils;
import org.toilelibre.libe.curl.StringUtils;

class HttpRequestProvider {
    HttpRequestProvider() {
    }

    static HttpUriRequest prepareRequest(CommandLine commandLine) throws Curl.CurlException {
        HttpRequestBase request = HttpRequestProvider.getBuilder(commandLine);
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest requestWithPayload = (HttpEntityEnclosingRequest)request;
            requestWithPayload.setEntity((HttpEntity)HttpRequestProvider.getData(commandLine));
            if (requestWithPayload.getEntity() == null) {
                requestWithPayload.setEntity(HttpRequestProvider.getForm(commandLine));
            }
        }
        HttpRequestProvider.setHeaders(commandLine, request);
        request.setConfig(HttpRequestProvider.getConfig(commandLine));
        return request;
    }

    private static boolean isBinary(String ref) {
        String fileName = Optional.ofNullable(ref).orElse("").trim() + " ";
        if (fileName.charAt(0) != '@') {
            return false;
        }
        File file = new File(fileName.substring(1).trim());
        return file.exists() && file.isFile();
    }

    private static byte[] dataBehind(String ref) {
        try {
            return IOUtils.toByteArray(new File(ref.substring(1).trim()));
        }
        catch (IOException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static HttpRequestBase getBuilder(CommandLine cl) throws Curl.CurlException {
        try {
            String method = cl.getOptionValue(Arguments.HTTP_METHOD.getOpt()) == null ? HttpRequestProvider.determineVerbWithoutArgument(cl) : cl.getOptionValue(Arguments.HTTP_METHOD.getOpt());
            return (HttpRequestBase)Class.forName(HttpRequestBase.class.getPackage().getName() + ".Http" + StringUtils.capitalize(method.toLowerCase().replaceAll("[^a-z]", ""))).getConstructor(URI.class).newInstance(new URI(cl.getArgs()[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | IllegalStateException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | URISyntaxException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static String determineVerbWithoutArgument(CommandLine commandLine) {
        if (commandLine.hasOption(Arguments.DATA.getOpt()) || commandLine.hasOption(Arguments.DATA_URLENCODE.getOpt()) || commandLine.hasOption(Arguments.FORM.getOpt())) {
            return "POST";
        }
        return "GET";
    }

    private static AbstractHttpEntity getData(CommandLine commandLine) {
        if (commandLine.hasOption(Arguments.DATA.getOpt())) {
            return HttpRequestProvider.simpleDataFrom(commandLine);
        }
        if (commandLine.hasOption(Arguments.DATA_BINARY.getOpt())) {
            return HttpRequestProvider.binaryDataFrom(commandLine);
        }
        if (commandLine.hasOption(Arguments.DATA_URLENCODE.getOpt())) {
            try {
                return new StringEntity(Arrays.stream(commandLine.getOptionValues(Arguments.DATA_URLENCODE.getOpt())).map(HttpRequestProvider::urlEncodedDataFrom).collect(Collectors.joining("&")));
            }
            catch (UnsupportedEncodingException e) {
                throw new Curl.CurlException(e);
            }
        }
        return null;
    }

    private static String urlEncodedDataFrom(String value) {
        if (value.startsWith("=")) {
            value = value.substring(1);
        }
        if (value.indexOf(61) != -1) {
            return value.substring(0, value.indexOf(61) + 1) + HttpRequestProvider.encodeOrFail(value.substring(value.indexOf(61) + 1), Charset.defaultCharset());
        }
        if (value.indexOf(64) == 0) {
            return HttpRequestProvider.encodeOrFail(new String(HttpRequestProvider.dataBehind(value)), Charset.defaultCharset());
        }
        if (value.indexOf(64) != -1) {
            return value.substring(0, value.indexOf(64)) + '=' + HttpRequestProvider.encodeOrFail(new String(HttpRequestProvider.dataBehind(value.substring(value.indexOf(64)))), Charset.defaultCharset());
        }
        return HttpRequestProvider.encodeOrFail(value, Charset.defaultCharset());
    }

    private static String encodeOrFail(String value, Charset encoding) {
        try {
            return URLEncoder.encode(value, encoding.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static InputStreamEntity binaryDataFrom(CommandLine commandLine) {
        String value = commandLine.getOptionValue(Arguments.DATA_BINARY.getOpt());
        if (value.indexOf(64) == 0) {
            return new InputStreamEntity((InputStream)new ByteArrayInputStream(HttpRequestProvider.dataBehind(value)));
        }
        return new InputStreamEntity((InputStream)new ByteArrayInputStream(value.getBytes()));
    }

    private static StringEntity simpleDataFrom(CommandLine commandLine) {
        try {
            return new StringEntity(commandLine.getOptionValue(Arguments.DATA.getOpt()));
        }
        catch (UnsupportedEncodingException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static HttpEntity getForm(CommandLine commandLine) {
        String[] forms = Optional.ofNullable(commandLine.getOptionValues(Arguments.FORM.getOpt())).orElse(new String[0]);
        if (forms.length == 0) {
            return null;
        }
        MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
        Arrays.stream(forms).forEach(arg -> {
            if (arg.indexOf(61) == -1) {
                throw new IllegalArgumentException("option -F: is badly used here");
            }
        });
        List<String> binaryForms = Arrays.stream(forms).filter(arg -> HttpRequestProvider.isBinary(arg.substring(arg.indexOf(61) + 1))).collect(Collectors.toList());
        List<String> textForms = Arrays.stream(forms).filter(form -> !binaryForms.contains(form)).collect(Collectors.toList());
        binaryForms.forEach(arg -> multiPartBuilder.addBinaryBody(arg.substring(0, arg.indexOf(61)), HttpRequestProvider.dataBehind(arg.substring(arg.indexOf(61) + 1))));
        textForms.forEach(arg -> multiPartBuilder.addTextBody(arg.substring(0, arg.indexOf(61)), arg.substring(arg.indexOf(61) + 1)));
        return multiPartBuilder.build();
    }

    private static void setHeaders(CommandLine commandLine, HttpRequestBase request) {
        String[] headers = Optional.ofNullable(commandLine.getOptionValues(Arguments.HEADER.getOpt())).orElse(new String[0]);
        Arrays.stream(headers).filter(optionAsString -> optionAsString.indexOf(58) != -1).map(optionAsString -> optionAsString.split(":")).map(optionAsArray -> new BasicHeader(optionAsArray[0].trim().replaceAll("^\"", "").replaceAll("\\\"$", "").replaceAll("^\\'", "").replaceAll("\\'$", ""), optionAsArray[1].trim())).forEach(arg_0 -> ((HttpRequestBase)request).addHeader(arg_0));
        if (commandLine.hasOption(Arguments.USER_AGENT.getOpt())) {
            request.addHeader("User-Agent", commandLine.getOptionValue(Arguments.USER_AGENT.getOpt()));
        }
        if (commandLine.hasOption(Arguments.DATA_URLENCODE.getOpt())) {
            request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        if (commandLine.hasOption(Arguments.PROXY_USER.getOpt())) {
            request.addHeader("Proxy-Authenticate", "Basic " + Base64.getEncoder().encodeToString(commandLine.getOptionValue(Arguments.PROXY_USER.getOpt()).getBytes()));
        }
    }

    private static RequestConfig getConfig(CommandLine commandLine) {
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        if (commandLine.hasOption(Arguments.PROXY.getOpt())) {
            String hostWithoutTrailingSlash = commandLine.getOptionValue(Arguments.PROXY.getOpt()).replaceFirst("\\s*/\\s*$", "");
            requestConfig.setProxy(HttpHost.create((String)hostWithoutTrailingSlash));
        }
        return requestConfig.build();
    }
}

