/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Base64;

class PemReader
extends BufferedReader {
    private static final String BEGIN = "-----BEGIN ";
    private static final String END = "-----END ";

    PemReader(Reader reader) {
        super(reader);
    }

    private PemObject loadObject(String type) throws IOException {
        String line;
        String endMarker = END + type;
        StringBuilder stringBuffer = new StringBuilder();
        while ((line = this.readLine()) != null) {
            if (line.contains(":")) continue;
            if (line.contains(endMarker)) break;
            stringBuffer.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        return new PemObject(type, Base64.getDecoder().decode(stringBuffer.toString()));
    }

    PemObject readPemObject() throws IOException {
        String line = this.readLine();
        while (line != null && !line.startsWith(BEGIN)) {
            line = this.readLine();
        }
        if (line != null) {
            line = line.substring(BEGIN.length());
            int index = line.indexOf(45);
            String type = line.substring(0, index);
            if (index > 0) {
                return this.loadObject(type);
            }
        }
        return null;
    }

    static class PemObject {
        private final byte[] content;
        private final String type;

        PemObject(String type, byte[] content) {
            this.type = type;
            this.content = content;
        }

        byte[] getContent() {
            return this.content;
        }

        String getType() {
            return this.type;
        }
    }
}

