/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.toilelibre.libe.curl.Curl;

enum CertFormat {
    PEM((inputStream, passwordAsCharArray) -> {
        try {
            PemObject pemObject;
            KeyStore keyStore = KeyStore.getInstance("JKS");
            KeyStore keyStore1 = KeyStore.getInstance("pkcs12");
            keyStore1.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("clients/libe/libe.p12"), passwordAsCharArray);
            PemReader pemReader = new PemReader((Reader)new InputStreamReader(inputStream));
            PKCS8EncodedKeySpec privateKeySpec = null;
            Certificate publicCertificate = null;
            while ((pemObject = pemReader.readPemObject()) != null) {
                switch (pemObject.getType()) {
                    case "PRIVATE KEY": {
                        privateKeySpec = new PKCS8EncodedKeySpec(pemObject.getContent());
                        break;
                    }
                    case "CERTIFICATE": {
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        publicCertificate = certificateFactory.generateCertificate(new ByteArrayInputStream(pemObject.getContent()));
                        break;
                    }
                }
            }
            pemReader.close();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
            keyStore.load(null);
            keyStore.setCertificateEntry("cert-alias", publicCertificate);
            keyStore.setKeyEntry("key-alias", privateKey, passwordAsCharArray, new Certificate[]{publicCertificate});
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            throw new Curl.CurlException(e);
        }
    }),
    P12((inputStream, passwordAsCharArray) -> {
        try {
            KeyStore keyStore = KeyStore.getInstance("pkcs12");
            keyStore.load(inputStream, passwordAsCharArray);
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new Curl.CurlException(e);
        }
    }),
    DER((inputStream, passwordAsCharArray) -> {
        try {
            return KeyStore.getInstance("pkcs12");
        }
        catch (KeyStoreException e) {
            throw new Curl.CurlException(e);
        }
    }),
    ENG((inputStream, passwordAsCharArray) -> {
        try {
            return KeyStore.getInstance("pkcs12");
        }
        catch (KeyStoreException e) {
            throw new Curl.CurlException(e);
        }
    });

    private KeystoreFromFileGenerator generator;

    private CertFormat(KeystoreFromFileGenerator generator1) {
        this.generator = generator1;
    }

    public KeystoreFromFileGenerator getGenerator() {
        return this.generator;
    }

    public KeyStore generateKeyStoreFromFileAndPassword(InputStream inputStream, char[] passwordAsCharArray) {
        return this.generator.generate(inputStream, passwordAsCharArray);
    }

    @FunctionalInterface
    static interface KeystoreFromFileGenerator {
        public KeyStore generate(InputStream var1, char[] var2);
    }
}

