/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.security.cert.CertificateException;
import org.apache.commons.cli.CommandLine;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.CertFormat;
import org.toilelibre.libe.curl.Curl;

final class HttpClientProvider {
    HttpClientProvider() {
    }

    static HttpClient prepareHttpClient(CommandLine commandLine) throws Curl.CurlException {
        String hostname;
        HttpClientBuilder executor = HttpClientBuilder.create();
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e1) {
            throw new RuntimeException(e1);
        }
        executor = HttpClientProvider.handleAuthMethod(commandLine, executor, hostname);
        if (!commandLine.hasOption(Arguments.FOLLOW_REDIRECTS.getOpt())) {
            executor.disableRedirectHandling();
        }
        HttpClientProvider.handleSSLParams(commandLine, executor);
        return executor.build();
    }

    private static void handleSSLParams(CommandLine commandLine, HttpClientBuilder executor) throws Curl.CurlException {
        CertFormat format;
        SSLContextBuilder builder = new SSLContextBuilder();
        if (commandLine.hasOption(Arguments.TRUST_INSECURE.getOpt())) {
            HttpClientProvider.sayTrustInsecure(builder);
        }
        CertFormat certFormat = format = commandLine.hasOption(Arguments.CERT_TYPE.getOpt()) ? CertFormat.valueOf(commandLine.getOptionValue(Arguments.CERT_TYPE.getOpt()).toUpperCase()) : CertFormat.PEM;
        if (commandLine.hasOption(Arguments.CERT.getOpt())) {
            String[] credentials = commandLine.getOptionValue(Arguments.CERT.getOpt()).split(":");
            HttpClientProvider.addClientCredentials(builder, format, credentials[0], credentials.length > 1 ? credentials[1] : null);
        }
        try {
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(builder.build());
            executor.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static void addClientCredentials(SSLContextBuilder builder, CertFormat certFormat, String filePath, String password) throws Curl.CurlException {
        try {
            File fileObject = HttpClientProvider.getFile(filePath);
            KeyStore keyStore = HttpClientProvider.generateKeyStore(certFormat, fileObject, password == null ? null : password.toCharArray());
            builder.loadKeyMaterial(keyStore, password == null ? null : password.toCharArray());
        }
        catch (IOException | GeneralSecurityException | CertificateException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static KeyStore generateKeyStore(CertFormat certFormat, File fileObject, char[] passwordAsCharArray) throws KeyStoreException, NoSuchAlgorithmException, java.security.cert.CertificateException, FileNotFoundException, IOException, Curl.CurlException, CertificateException {
        return certFormat.generateKeyStoreFromFileAndPassword(new FileInputStream(fileObject), passwordAsCharArray);
    }

    private static File getFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        return new File(System.getProperty("user.dir") + File.separator + filePath);
    }

    private static void sayTrustInsecure(SSLContextBuilder builder) throws Curl.CurlException {
        try {
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static HttpClientBuilder handleAuthMethod(CommandLine commandLine, HttpClientBuilder executor, String hostname) {
        if (commandLine.getOptionValue(Arguments.AUTH.getOpt()) != null) {
            String[] authValue = commandLine.getOptionValue(Arguments.AUTH.getOpt()).toString().split("(?<!\\\\):");
            if (commandLine.hasOption(Arguments.NTLM.getOpt())) {
                String[] userName = authValue[0].split("\\\\");
                SystemDefaultCredentialsProvider systemDefaultCredentialsProvider = new SystemDefaultCredentialsProvider();
                systemDefaultCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(userName[1], authValue[1], hostname, userName[0]));
                executor = executor.setDefaultCredentialsProvider((CredentialsProvider)systemDefaultCredentialsProvider);
            } else {
                BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                basicCredentialsProvider.setCredentials(new AuthScope(HttpHost.create((String)URI.create(commandLine.getArgs()[0]).getHost())), (Credentials)new UsernamePasswordCredentials(authValue[0], authValue[1]));
                executor = executor.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
            }
        }
        return executor;
    }
}

