/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.Curl;
import org.toilelibre.libe.curl.StringUtils;

class HttpRequestProvider {
    HttpRequestProvider() {
    }

    static HttpUriRequest prepareRequest(CommandLine commandLine) throws Curl.CurlException {
        HttpUriRequest request = HttpRequestProvider.getBuilder(commandLine);
        if (commandLine.hasOption(Arguments.DATA.getOpt()) && request instanceof HttpEntityEnclosingRequest) {
            try {
                ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new StringEntity(commandLine.getOptionValue(Arguments.DATA.getOpt()).toString()));
            }
            catch (UnsupportedEncodingException e) {
                throw new Curl.CurlException(e);
            }
        }
        String[] headers = Optional.ofNullable(commandLine.getOptionValues(Arguments.HEADER.getOpt())).orElse(new String[0]);
        Arrays.asList(headers).stream().map(optionAsString -> optionAsString.split(":")).map(optionAsArray -> new BasicHeader(optionAsArray[0].trim().replaceAll("^\"", "").replaceAll("\\\"$", "").replaceAll("^\\'", "").replaceAll("\\'$", ""), optionAsArray[1].trim())).forEach(basicHeader -> request.addHeader((Header)basicHeader));
        return request;
    }

    private static HttpUriRequest getBuilder(CommandLine cl) throws Curl.CurlException {
        try {
            String method = (cl.getOptionValue(Arguments.HTTP_METHOD.getOpt()) == null ? "GET" : cl.getOptionValue(Arguments.HTTP_METHOD.getOpt())).toString();
            return (HttpUriRequest)Class.forName(HttpRequestBase.class.getPackage().getName() + ".Http" + StringUtils.capitalize(method.toLowerCase().replaceAll("[^a-z]", ""))).getConstructor(URI.class).newInstance(new URI(cl.getArgs()[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | IllegalStateException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | URISyntaxException e) {
            throw new Curl.CurlException(e);
        }
    }
}

