/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.cli.CommandLine;
import org.apache.http.HttpResponse;
import org.toilelibre.libe.curl.AfterResponse;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.HttpClientProvider;
import org.toilelibre.libe.curl.HttpRequestProvider;
import org.toilelibre.libe.curl.IOUtils;
import org.toilelibre.libe.curl.ReadArguments;
import org.toilelibre.libe.curl.UglyVersionDisplay;

public class Curl {
    private Curl() {
    }

    public static String $(String requestCommand) throws CurlException {
        try {
            return IOUtils.quietToString(Curl.curlAsync(requestCommand).get().getEntity());
        }
        catch (InterruptedException | UnsupportedOperationException | ExecutionException e) {
            throw new CurlException(e);
        }
    }

    public static CompletableFuture<String> $Async(String requestCommand) throws CurlException {
        return Curl.curlAsync(requestCommand).thenApply(httpResponse -> IOUtils.quietToString(httpResponse.getEntity()));
    }

    public static CurlArgumentsBuilder curl() {
        return new CurlArgumentsBuilder();
    }

    public static HttpResponse curl(String requestCommand) throws CurlException {
        try {
            return Curl.curlAsync(requestCommand).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CurlException(e);
        }
    }

    public static CompletableFuture<HttpResponse> curlAsync(String requestCommand) throws CurlException {
        return CompletableFuture.supplyAsync(() -> {
            CommandLine commandLine = ReadArguments.getCommandLineFromRequest(requestCommand);
            try {
                UglyVersionDisplay.stopAndDisplayVersionIfThe(commandLine.hasOption(Arguments.VERSION.getOpt()));
                HttpResponse response = HttpClientProvider.prepareHttpClient(commandLine).execute(HttpRequestProvider.prepareRequest(commandLine));
                AfterResponse.handle(commandLine, response);
                return response;
            }
            catch (IOException | IllegalArgumentException e) {
                throw new CurlException(e);
            }
        }).toCompletableFuture();
    }

    public static class CurlException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CurlException(Throwable arg0) {
            super(arg0);
        }
    }

    public static class CurlArgumentsBuilder {
        private final StringBuilder curlCommand = new StringBuilder("curl ");

        CurlArgumentsBuilder() {
        }

        public String $(String url) throws CurlException {
            this.curlCommand.append(url).append(" ");
            return Curl.$(this.curlCommand.toString());
        }

        public CompletableFuture<String> $Async(String url) throws CurlException {
            this.curlCommand.append(url).append(" ");
            return Curl.$Async(this.curlCommand.toString());
        }

        public HttpResponse run(String url) throws CurlException {
            this.curlCommand.append(url).append(" ");
            return Curl.curl(this.curlCommand.toString());
        }

        public CompletableFuture<HttpResponse> runAsync(String url) throws CurlException {
            this.curlCommand.append(url).append(" ");
            return Curl.curlAsync(this.curlCommand.toString());
        }

        public CurlArgumentsBuilder u(String string) {
            this.curlCommand.append(new StringBuffer().append("-u ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder username(String string) {
            this.curlCommand.append(new StringBuffer().append("--username ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder cacert(String string) {
            this.curlCommand.append(new StringBuffer().append("--cacert ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder eUpperCase(String string) {
            this.curlCommand.append(new StringBuffer().append("-E ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder cert(String string) {
            this.curlCommand.append(new StringBuffer().append("--cert ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder ct(String string) {
            this.curlCommand.append(new StringBuffer().append("--ct ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder certtype(String string) {
            this.curlCommand.append(new StringBuffer().append("--cert-type ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder d(String string) {
            this.curlCommand.append(new StringBuffer().append("-d ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder data(String string) {
            this.curlCommand.append(new StringBuffer().append("--data ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder databinary(String string) {
            this.curlCommand.append(new StringBuffer().append("--databinary ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder dataurlencode(String string) {
            this.curlCommand.append(new StringBuffer().append("--dataurlencode ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder lUpperCase() {
            this.curlCommand.append("-L ");
            return this;
        }

        public CurlArgumentsBuilder location() {
            this.curlCommand.append("--location ");
            return this;
        }

        public CurlArgumentsBuilder fUpperCase(String string) {
            this.curlCommand.append(new StringBuffer().append("-F ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder form(String string) {
            this.curlCommand.append(new StringBuffer().append("--form ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder hUpperCase(String string) {
            this.curlCommand.append(new StringBuffer().append("-H ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder header(String string) {
            this.curlCommand.append(new StringBuffer().append("--header ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder xUpperCase(String string) {
            this.curlCommand.append(new StringBuffer().append("-X ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder request(String string) {
            this.curlCommand.append(new StringBuffer().append("--request ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder key(String string) {
            this.curlCommand.append(new StringBuffer().append("--key ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder kt(String string) {
            this.curlCommand.append(new StringBuffer().append("--kt ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder keytype(String string) {
            this.curlCommand.append(new StringBuffer().append("--key-type ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder ntlm() {
            this.curlCommand.append("--ntlm ");
            return this;
        }

        public CurlArgumentsBuilder o(String string) {
            this.curlCommand.append(new StringBuffer().append("-o ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder output(String string) {
            this.curlCommand.append(new StringBuffer().append("--output ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder x(String string) {
            this.curlCommand.append(new StringBuffer().append("-x ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder proxy(String string) {
            this.curlCommand.append(new StringBuffer().append("--proxy ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder uUpperCase(String string) {
            this.curlCommand.append(new StringBuffer().append("-U ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder proxyuser(String string) {
            this.curlCommand.append(new StringBuffer().append("--proxy-user ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder one() {
            this.curlCommand.append("-1 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv1() {
            this.curlCommand.append("--tlsv1 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv10() {
            this.curlCommand.append("--tlsv10 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv1zero() {
            this.curlCommand.append("--tlsv1.0 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv11() {
            this.curlCommand.append("--tlsv11 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv1one() {
            this.curlCommand.append("--tlsv1.1 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv12() {
            this.curlCommand.append("--tlsv12 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv1two() {
            this.curlCommand.append("--tlsv1.2 ");
            return this;
        }

        public CurlArgumentsBuilder two() {
            this.curlCommand.append("-2 ");
            return this;
        }

        public CurlArgumentsBuilder sslv2() {
            this.curlCommand.append("--sslv2 ");
            return this;
        }

        public CurlArgumentsBuilder three() {
            this.curlCommand.append("-3 ");
            return this;
        }

        public CurlArgumentsBuilder sslv3() {
            this.curlCommand.append("--sslv3 ");
            return this;
        }

        public CurlArgumentsBuilder k() {
            this.curlCommand.append("-k ");
            return this;
        }

        public CurlArgumentsBuilder insecure() {
            this.curlCommand.append("--insecure ");
            return this;
        }

        public CurlArgumentsBuilder aUpperCase(String string) {
            this.curlCommand.append(new StringBuffer().append("-A ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder useragent(String string) {
            this.curlCommand.append(new StringBuffer().append("--user-agent ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder vUpperCase() {
            this.curlCommand.append("-V ");
            return this;
        }

        public CurlArgumentsBuilder version() {
            this.curlCommand.append("--version ");
            return this;
        }
    }
}

