/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;

class DerReader {
    private static final int BMP_STRING = 30;
    private static final int BYTE_MAX = 255;
    private static final int CONSTRUCTED = 32;
    private static final int GENERAL_STRING = 27;
    private static final int GRAPHIC_STRING = 25;
    private static final int IA5_STRING = 22;
    private static final int INTEGER = 2;
    private static final int ISO646_STRING = 26;
    private static final byte LOWER_7_BITS = 127;
    private static final int MAX_NUMBER_OF_BYTES = 4;
    private static final int NUMERIC_STRING = 18;
    private static final int PRINTABLE_STRING = 19;
    private static final int UNIVERSAL_STRING = 28;
    private static final int UTF8_STRING = 12;
    private static final int VIDEOTEX_STRING = 21;
    private final InputStream in;

    DerReader(byte[] bytes) {
        this(new ByteArrayInputStream(bytes));
    }

    private DerReader(InputStream in) {
        this.in = in;
    }

    private int getLength() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            throw new IOException("Invalid DER: length missing");
        }
        if ((i & 0xFFFFFF80) == 0) {
            return i;
        }
        int num = i & 0x7F;
        if (i >= 255 || num > 4) {
            throw new IOException("Invalid DER: length field too big (" + i + ")");
        }
        byte[] bytes = new byte[num];
        int n = this.in.read(bytes);
        if (n < num) {
            throw new IOException("Invalid DER: length too short");
        }
        return new BigInteger(1, bytes).intValue();
    }

    Asn1Object read() throws IOException {
        int tag = this.in.read();
        if (tag == -1) {
            throw new IOException("Invalid DER: stream too short, missing tag");
        }
        int length = this.getLength();
        byte[] value = new byte[length];
        int n = this.in.read(value);
        if (n < length) {
            throw new IOException("Invalid DER: stream too short, missing value");
        }
        return new Asn1Object(tag, value);
    }

    static class Asn1Object {
        private static final byte LOWER_5_BITS = 31;
        private final int tag;
        private final int type;
        private final byte[] value;

        Asn1Object(int tag, byte[] value) {
            this.tag = tag;
            this.type = tag & 0x1F;
            this.value = value;
        }

        BigInteger getInteger() throws IOException {
            if (this.type != 2) {
                throw new IOException("Invalid DER: object is not integer");
            }
            return new BigInteger(this.value);
        }

        KeySpec getKeySpec() throws IOException {
            DerReader parser = this.getReader();
            parser.read();
            BigInteger modulus = parser.read().getInteger();
            BigInteger publicExp = parser.read().getInteger();
            BigInteger privateExp = parser.read().getInteger();
            BigInteger prime1 = parser.read().getInteger();
            BigInteger prime2 = parser.read().getInteger();
            BigInteger exp1 = parser.read().getInteger();
            BigInteger exp2 = parser.read().getInteger();
            BigInteger crtCoef = parser.read().getInteger();
            return new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
        }

        DerReader getReader() throws IOException {
            if (!this.isConstructed()) {
                throw new IOException("Invalid DER: can't parse primitive entity");
            }
            return new DerReader(this.value);
        }

        public String getString() throws IOException {
            String encoding;
            switch (this.type) {
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 25: 
                case 26: 
                case 27: {
                    encoding = "ISO-8859-1";
                    break;
                }
                case 30: {
                    encoding = "UTF-16BE";
                    break;
                }
                case 12: {
                    encoding = "UTF-8";
                    break;
                }
                case 28: {
                    throw new IOException("Invalid DER: can't handle UCS-4 string");
                }
                default: {
                    throw new IOException("Invalid DER: object is not a string");
                }
            }
            return new String(this.value, encoding);
        }

        boolean isConstructed() {
            return (this.tag & 0x20) == 32;
        }
    }
}

