/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.Curl;

final class ReadArguments {
    private static final Pattern PLACEHOLDER_REGEX = Pattern.compile("^\\$curl_placeholder_[0-9]+$");

    ReadArguments() {
    }

    static CommandLine getCommandLineFromRequest(String requestCommand, List<String> placeholderValues) {
        CommandLine commandLine;
        DefaultParser parser = new DefaultParser();
        String requestCommandWithoutBasename = requestCommand.replaceAll("^[ ]*curl[ ]*", " ") + " ";
        String[] args = ReadArguments.getArgsFromCommand(requestCommandWithoutBasename, placeholderValues);
        try {
            commandLine = parser.parse(Arguments.ALL_OPTIONS, args);
        }
        catch (ParseException e) {
            new HelpFormatter().printHelp("curl [options] url", Arguments.ALL_OPTIONS);
            throw new Curl.CurlException(e);
        }
        return commandLine;
    }

    private static String[] getArgsFromCommand(String requestCommandWithoutBasename, List<String> placeholderValues) {
        String requestCommandInput = requestCommandWithoutBasename.replaceAll("\\s+-([a-zA-Z0-9])", " -$1 ");
        Matcher matcher = Arguments.ARGS_SPLIT_REGEX.matcher(requestCommandInput);
        ArrayList<String> args = new ArrayList<String>();
        while (matcher.find()) {
            String argument = ReadArguments.removeSlashes(matcher.group(1).trim());
            if (PLACEHOLDER_REGEX.matcher(argument).matches()) {
                args.add(placeholderValues.get(Integer.parseInt(argument.substring("$curl_placeholder_".length()))));
                continue;
            }
            args.add(argument);
        }
        return args.toArray(new String[0]);
    }

    private static String removeSlashes(String arg) {
        if (arg.length() == 0) {
            return arg;
        }
        if (arg.charAt(0) == '\"') {
            return arg.substring(1, arg.length() - 1).replaceAll("\\\"", "\"");
        }
        if (arg.charAt(0) == '\'') {
            return arg.substring(1, arg.length() - 1).replaceAll("\\'", "'");
        }
        return arg;
    }
}

