/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.HttpClientConnectionManager;
import org.toilelibre.libe.curl.AfterResponse;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.HttpClientProvider;
import org.toilelibre.libe.curl.HttpRequestProvider;
import org.toilelibre.libe.curl.IOUtils;
import org.toilelibre.libe.curl.ReadArguments;
import org.toilelibre.libe.curl.UglyVersionDisplay;

public class Curl {
    private Curl() {
    }

    public static String $(String requestCommand) throws CurlException {
        return Curl.$(requestCommand, CurlArgumentsBuilder.CurlJavaOptions.with().build());
    }

    public static String $(String requestCommand, CurlArgumentsBuilder.CurlJavaOptions curlJavaOptions) throws CurlException {
        try {
            return IOUtils.quietToString(Curl.curlAsync(requestCommand, curlJavaOptions).get().getEntity());
        }
        catch (InterruptedException | UnsupportedOperationException | ExecutionException e) {
            throw new CurlException(e);
        }
    }

    public static CompletableFuture<String> $Async(String requestCommand) throws CurlException {
        return Curl.$Async(requestCommand, CurlArgumentsBuilder.CurlJavaOptions.with().build());
    }

    public static CompletableFuture<String> $Async(String requestCommand, CurlArgumentsBuilder.CurlJavaOptions curlJavaOptions) throws CurlException {
        return Curl.curlAsync(requestCommand, curlJavaOptions).thenApply(httpResponse -> IOUtils.quietToString(httpResponse.getEntity()));
    }

    public static CurlArgumentsBuilder curl() {
        return new CurlArgumentsBuilder();
    }

    public static HttpResponse curl(String requestCommand) throws CurlException {
        return Curl.curl(requestCommand, CurlArgumentsBuilder.CurlJavaOptions.with().build());
    }

    public static HttpResponse curl(String requestCommand, CurlArgumentsBuilder.CurlJavaOptions curlJavaOptions) throws CurlException {
        try {
            return Curl.curlAsync(requestCommand, curlJavaOptions).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CurlException(e);
        }
    }

    public static CompletableFuture<HttpResponse> curlAsync(String requestCommand) throws CurlException {
        return Curl.curlAsync(requestCommand, CurlArgumentsBuilder.CurlJavaOptions.with().build());
    }

    public static CompletableFuture<HttpResponse> curlAsync(String requestCommand, CurlArgumentsBuilder.CurlJavaOptions curlJavaOptions) throws CurlException {
        return CompletableFuture.supplyAsync(() -> {
            CommandLine commandLine = ReadArguments.getCommandLineFromRequest(requestCommand, curlJavaOptions.getPlaceHolders());
            try {
                UglyVersionDisplay.stopAndDisplayVersionIfThe(commandLine.hasOption(Arguments.VERSION.getOpt()));
                HttpResponse response = HttpClientProvider.prepareHttpClient(commandLine, curlJavaOptions.getInterceptors(), curlJavaOptions.connectionManager).execute(HttpRequestProvider.prepareRequest(commandLine));
                AfterResponse.handle(commandLine, response);
                return response;
            }
            catch (IOException | IllegalArgumentException e) {
                throw new CurlException(e);
            }
        }).toCompletableFuture();
    }

    public static class CurlException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CurlException(Throwable arg0) {
            super(arg0);
        }
    }

    public static class CurlArgumentsBuilder {
        private final StringBuilder curlCommand = new StringBuilder("curl ");
        private CurlJavaOptions curlJavaOptions = CurlJavaOptions.with().build();

        CurlArgumentsBuilder() {
        }

        public CurlArgumentsBuilder javaOptions(CurlJavaOptions curlJavaOptions) {
            this.curlJavaOptions = curlJavaOptions;
            return this;
        }

        public String $(String url) throws CurlException {
            this.curlCommand.append(url).append(" ");
            return Curl.$(this.curlCommand.toString(), this.curlJavaOptions);
        }

        public CompletableFuture<String> $Async(String url) throws CurlException {
            this.curlCommand.append(url).append(" ");
            return Curl.$Async(this.curlCommand.toString(), this.curlJavaOptions);
        }

        public HttpResponse run(String url) throws CurlException {
            this.curlCommand.append(url).append(" ");
            return Curl.curl(this.curlCommand.toString(), this.curlJavaOptions);
        }

        public CompletableFuture<HttpResponse> runAsync(String url) throws CurlException {
            this.curlCommand.append(url).append(" ");
            return Curl.curlAsync(this.curlCommand.toString(), this.curlJavaOptions);
        }

        public CurlArgumentsBuilder u(String string) {
            this.curlCommand.append(new StringBuffer().append("-u ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder username(String string) {
            this.curlCommand.append(new StringBuffer().append("--username ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder cacert(String string) {
            this.curlCommand.append(new StringBuffer().append("--cacert ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder eUpperCase(String string) {
            this.curlCommand.append(new StringBuffer().append("-E ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder cert(String string) {
            this.curlCommand.append(new StringBuffer().append("--cert ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder ct(String string) {
            this.curlCommand.append(new StringBuffer().append("--ct ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder certtype(String string) {
            this.curlCommand.append(new StringBuffer().append("--cert-type ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder cti(String string) {
            this.curlCommand.append(new StringBuffer().append("--cti ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder connecttimeout(String string) {
            this.curlCommand.append(new StringBuffer().append("--connect-timeout ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder d(String string) {
            this.curlCommand.append(new StringBuffer().append("-d ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder data(String string) {
            this.curlCommand.append(new StringBuffer().append("--data ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder databinary(String string) {
            this.curlCommand.append(new StringBuffer().append("--databinary ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder dataurlencode(String string) {
            this.curlCommand.append(new StringBuffer().append("--dataurlencode ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder lUpperCase() {
            this.curlCommand.append("-L ");
            return this;
        }

        public CurlArgumentsBuilder location() {
            this.curlCommand.append("--location ");
            return this;
        }

        public CurlArgumentsBuilder fUpperCase(String string) {
            this.curlCommand.append(new StringBuffer().append("-F ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder form(String string) {
            this.curlCommand.append(new StringBuffer().append("--form ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder hUpperCase(String string) {
            this.curlCommand.append(new StringBuffer().append("-H ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder header(String string) {
            this.curlCommand.append(new StringBuffer().append("--header ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder xUpperCase(String string) {
            this.curlCommand.append(new StringBuffer().append("-X ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder request(String string) {
            this.curlCommand.append(new StringBuffer().append("--request ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder key(String string) {
            this.curlCommand.append(new StringBuffer().append("--key ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder kt(String string) {
            this.curlCommand.append(new StringBuffer().append("--kt ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder keytype(String string) {
            this.curlCommand.append(new StringBuffer().append("--key-type ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder m(String string) {
            this.curlCommand.append(new StringBuffer().append("-m ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder maxtime(String string) {
            this.curlCommand.append(new StringBuffer().append("--max-time ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder ntlm() {
            this.curlCommand.append("--ntlm ");
            return this;
        }

        public CurlArgumentsBuilder o(String string) {
            this.curlCommand.append(new StringBuffer().append("-o ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder output(String string) {
            this.curlCommand.append(new StringBuffer().append("--output ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder x(String string) {
            this.curlCommand.append(new StringBuffer().append("-x ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder proxy(String string) {
            this.curlCommand.append(new StringBuffer().append("--proxy ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder uUpperCase(String string) {
            this.curlCommand.append(new StringBuffer().append("-U ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder proxyuser(String string) {
            this.curlCommand.append(new StringBuffer().append("--proxy-user ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder one() {
            this.curlCommand.append("-1 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv1() {
            this.curlCommand.append("--tlsv1 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv10() {
            this.curlCommand.append("--tlsv10 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv1zero() {
            this.curlCommand.append("--tlsv1.0 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv11() {
            this.curlCommand.append("--tlsv11 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv1one() {
            this.curlCommand.append("--tlsv1.1 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv12() {
            this.curlCommand.append("--tlsv12 ");
            return this;
        }

        public CurlArgumentsBuilder tlsv1two() {
            this.curlCommand.append("--tlsv1.2 ");
            return this;
        }

        public CurlArgumentsBuilder two() {
            this.curlCommand.append("-2 ");
            return this;
        }

        public CurlArgumentsBuilder sslv2() {
            this.curlCommand.append("--sslv2 ");
            return this;
        }

        public CurlArgumentsBuilder three() {
            this.curlCommand.append("-3 ");
            return this;
        }

        public CurlArgumentsBuilder sslv3() {
            this.curlCommand.append("--sslv3 ");
            return this;
        }

        public CurlArgumentsBuilder k() {
            this.curlCommand.append("-k ");
            return this;
        }

        public CurlArgumentsBuilder insecure() {
            this.curlCommand.append("--insecure ");
            return this;
        }

        public CurlArgumentsBuilder aUpperCase(String string) {
            this.curlCommand.append(new StringBuffer().append("-A ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder useragent(String string) {
            this.curlCommand.append(new StringBuffer().append("--user-agent ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder vUpperCase() {
            this.curlCommand.append("-V ");
            return this;
        }

        public CurlArgumentsBuilder version() {
            this.curlCommand.append("--version ");
            return this;
        }

        public CurlArgumentsBuilder interceptor(String string) {
            this.curlCommand.append(new StringBuffer().append("--interceptor ").append(string).append(" ").toString());
            return this;
        }

        public static class CurlJavaOptions {
            private final List<BiFunction<HttpRequest, Supplier<HttpResponse>, HttpResponse>> interceptors;
            private final List<String> placeHolders;
            private final HttpClientConnectionManager connectionManager;

            private CurlJavaOptions(Builder builder) {
                this.interceptors = builder.interceptors;
                this.placeHolders = builder.placeHolders;
                this.connectionManager = builder.connectionManager;
            }

            public static Builder with() {
                return new Builder();
            }

            public List<BiFunction<HttpRequest, Supplier<HttpResponse>, HttpResponse>> getInterceptors() {
                return this.interceptors;
            }

            public List<String> getPlaceHolders() {
                return this.placeHolders;
            }

            public static final class Builder {
                private List<BiFunction<HttpRequest, Supplier<HttpResponse>, HttpResponse>> interceptors = new ArrayList<BiFunction<HttpRequest, Supplier<HttpResponse>, HttpResponse>>();
                private List<String> placeHolders;
                private HttpClientConnectionManager connectionManager;

                private Builder() {
                }

                public Builder interceptor(BiFunction<HttpRequest, Supplier<HttpResponse>, HttpResponse> val) {
                    this.interceptors.add(val);
                    return this;
                }

                public Builder placeHolders(List<String> val) {
                    this.placeHolders = val;
                    return this;
                }

                public Builder connectionManager(HttpClientConnectionManager val) {
                    this.connectionManager = val;
                    return this;
                }

                public CurlJavaOptions build() {
                    return new CurlJavaOptions(this);
                }
            }
        }
    }
}

