/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Enumeration;
import org.toilelibre.libe.curl.Curl;
import org.toilelibre.libe.curl.PemReader;

enum CertFormat {
    PEM((inputStream, kind, passwordAsCharArray) -> {
        BufferedReader pemReader = null;
        try {
            PemReader.PemObject pemObject;
            pemReader = new PemReader(new InputStreamReader(inputStream));
            PKCS8EncodedKeySpec privateKeySpec = null;
            while ((pemObject = ((PemReader)pemReader).readPemObject()) != null) {
                Kind readKind = Kind.fromValue(pemObject.getType());
                if (kind != readKind) continue;
                switch (kind) {
                    case PRIVATE_KEY: {
                        privateKeySpec = new PKCS8EncodedKeySpec(pemObject.getContent());
                        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
                        return privateKey;
                    }
                    case CERTIFICATE: {
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(pemObject.getContent()));
                        return certificate;
                    }
                }
                Object var9_14 = null;
                return var9_14;
            }
            Object var6_7 = null;
            return var6_7;
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            throw new Curl.CurlException(e);
        }
        finally {
            if (pemReader != null) {
                try {
                    pemReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }),
    P12((inputStream, kind, passwordAsCharArray) -> {
        try {
            KeyStore keyStore = KeyStore.getInstance("pkcs12");
            keyStore.load(inputStream, passwordAsCharArray);
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (keyStore.getCertificate(alias) != null && kind == Kind.CERTIFICATE) {
                    return keyStore.getCertificate(alias);
                }
                if (keyStore.getKey(alias, passwordAsCharArray) == null || kind != Kind.PRIVATE_KEY) continue;
                return keyStore.getKey(alias, passwordAsCharArray);
            }
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new Curl.CurlException(e);
        }
    }),
    DER((inputStream, kind, passwordAsCharArray) -> {
        try {
            return KeyStore.getInstance("pkcs12");
        }
        catch (KeyStoreException e) {
            throw new Curl.CurlException(e);
        }
    }),
    ENG((inputStream, kind, passwordAsCharArray) -> {
        try {
            return KeyStore.getInstance("pkcs12");
        }
        catch (KeyStoreException e) {
            throw new Curl.CurlException(e);
        }
    });

    private KeystoreFromFileGenerator generator;

    private CertFormat(KeystoreFromFileGenerator generator1) {
        this.generator = generator1;
    }

    public KeystoreFromFileGenerator getGenerator() {
        return this.generator;
    }

    public <T> T generateCredentialsFromFileAndPassword(InputStream inputStream, Kind kind, char[] passwordAsCharArray) {
        return (T)this.generator.generate(inputStream, kind, passwordAsCharArray);
    }

    static enum Kind {
        PRIVATE_KEY,
        CERTIFICATE;


        static Kind fromValue(String value) {
            try {
                return Kind.valueOf(value.toUpperCase().replace(' ', '_'));
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
    }

    @FunctionalInterface
    static interface KeystoreFromFileGenerator {
        public Object generate(InputStream var1, Kind var2, char[] var3);
    }
}

