/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;

class PemReader
extends BufferedReader {
    private static final String BEGIN = "-----BEGIN ";
    private static final String END = "-----END ";

    PemReader(Reader reader) {
        super(reader);
    }

    PemObject readPemObject() throws IOException {
        String line = this.readLine();
        while (line != null && !line.startsWith(BEGIN)) {
            line = this.readLine();
        }
        if (line != null) {
            line = line.substring(BEGIN.length());
            int index = line.indexOf(45);
            String type = line.substring(0, index);
            if (index > 0) {
                return this.loadObject(type);
            }
        }
        return null;
    }

    private PemObject loadObject(String type) throws IOException {
        String line;
        String endMarker = END + type;
        StringBuilder stringBuffer = new StringBuilder();
        ArrayList<PemHeader> headers = new ArrayList<PemHeader>();
        while ((line = this.readLine()) != null) {
            if (line.contains(":")) {
                int index = line.indexOf(58);
                String hdr = line.substring(0, index);
                String value = line.substring(index + 1).trim();
                headers.add(new PemHeader(hdr, value));
                continue;
            }
            if (line.contains(endMarker)) break;
            stringBuffer.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        return new PemObject(type, headers, Base64.getDecoder().decode(stringBuffer.toString()));
    }

    static class PemObject {
        private String type;
        private List<PemHeader> headers;
        private byte[] content;

        PemObject(String type, List<PemHeader> headers, byte[] content) {
            this.type = type;
            this.headers = Collections.unmodifiableList(headers);
            this.content = content;
        }

        String getType() {
            return this.type;
        }

        byte[] getContent() {
            return this.content;
        }

        List<PemHeader> getHeaders() {
            return this.headers;
        }
    }

    static class PemHeader {
        private final String name;
        private final String value;

        PemHeader(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

