/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.toilelibre.libe.curl.Curl;

class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    IOUtils() {
    }

    private static void copy(InputStream input, Writer output, Charset encoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        IOUtils.copy(in, output);
    }

    private static int copy(Reader input, Writer output) throws IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private static long copyLarge(Reader input, Writer output) throws IOException {
        return IOUtils.copyLarge(input, output, new char[4096]);
    }

    private static long copyLarge(Reader input, Writer output, char[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    static byte[] toByteArray(File fileObject) throws IOException {
        FileInputStream fis = new FileInputStream(fileObject);
        return IOUtils.toByteArray(fis, (int)fileObject.length());
    }

    static byte[] toByteArray(InputStream fis, int length) throws IOException {
        byte[] result = new byte[length];
        DataInputStream dis = new DataInputStream(fis);
        dis.readFully(result);
        dis.close();
        fis.close();
        return result;
    }

    static byte[] toByteArray(InputStream fis) throws IOException {
        int read;
        byte[] chunk = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((read = fis.read(chunk)) != -1) {
            byteArrayOutputStream.write(chunk, 0, read);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static String quietToString(HttpEntity entity) {
        try {
            if (entity == null || entity.getContent() == null) {
                return null;
            }
            return IOUtils.toString(entity.getContent(), Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static String toString(InputStream input, Charset encoding) throws IOException {
        StringBuilderWriter sw = new StringBuilderWriter();
        IOUtils.copy(input, sw, encoding);
        return sw.toString();
    }

    private static class StringBuilderWriter
    extends Writer
    implements Serializable {
        private static final long serialVersionUID = 8461966367767048539L;
        private final StringBuilder builder = new StringBuilder();

        StringBuilderWriter() {
        }

        @Override
        public Writer append(char value) {
            this.builder.append(value);
            return this;
        }

        @Override
        public Writer append(CharSequence value) {
            this.builder.append(value);
            return this;
        }

        @Override
        public Writer append(CharSequence value, int start, int end) {
            this.builder.append(value, start, end);
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        public String toString() {
            return this.builder.toString();
        }

        @Override
        public void write(char[] value, int offset, int length) {
            this.builder.append(value, offset, length);
        }

        @Override
        public void write(String value) {
            this.builder.append(value);
        }
    }
}

