/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.AuthMethodHandler;
import org.toilelibre.libe.curl.Curl;
import org.toilelibre.libe.curl.InterceptorsBinder;
import org.toilelibre.libe.curl.SSLMaterialCreator;

final class HttpClientProvider {
    HttpClientProvider() {
    }

    static HttpClient prepareHttpClient(CommandLine commandLine, List<BiFunction<HttpRequest, Supplier<HttpResponse>, HttpResponse>> additionalInterceptors, HttpClientConnectionManager connectionManager) throws Curl.CurlException {
        String hostname;
        HttpClientBuilder executor = HttpClientBuilder.create();
        if (connectionManager != null) {
            executor.setConnectionManager(connectionManager);
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e1) {
            throw new RuntimeException(e1);
        }
        executor = AuthMethodHandler.handleAuthMethod(commandLine, executor, hostname);
        if (!commandLine.hasOption(Arguments.FOLLOW_REDIRECTS.getOpt())) {
            executor.disableRedirectHandling();
        }
        SSLMaterialCreator.handleSSLParams(commandLine, executor);
        InterceptorsBinder.handleInterceptors(commandLine, executor, additionalInterceptors);
        return executor.build();
    }
}

