/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.VersionInfo;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.Curl;
import org.toilelibre.libe.curl.IOUtils;
import org.toilelibre.libe.curl.PayloadReader;
import org.toilelibre.libe.curl.Version;

final class HttpRequestProvider {
    HttpRequestProvider() {
    }

    static HttpUriRequest prepareRequest(CommandLine commandLine) throws Curl.CurlException {
        String method = HttpRequestProvider.getMethod(commandLine);
        RequestBuilder request = HttpRequestProvider.wrapInRequestBuilder(method, commandLine.getArgs()[0]);
        if (Arrays.asList("DELETE", "PATCH", "POST", "PUT").contains(method.toUpperCase())) {
            request.setEntity((HttpEntity)PayloadReader.getData(commandLine));
            if (request.getEntity() == null) {
                request.setEntity(HttpRequestProvider.getForm(commandLine));
            }
        }
        HttpRequestProvider.setHeaders(commandLine, request);
        request.setConfig(HttpRequestProvider.getConfig(commandLine));
        return request.build();
    }

    private static String getMethod(CommandLine cl) throws Curl.CurlException {
        return cl.getOptionValue(Arguments.HTTP_METHOD.getOpt()) == null ? HttpRequestProvider.determineVerbWithoutArgument(cl) : cl.getOptionValue(Arguments.HTTP_METHOD.getOpt());
    }

    private static RequestBuilder wrapInRequestBuilder(String method, String uriAsString) {
        try {
            return RequestBuilder.create((String)method).setUri(new URI(uriAsString));
        }
        catch (URISyntaxException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static String determineVerbWithoutArgument(CommandLine commandLine) {
        if (commandLine.hasOption(Arguments.DATA.getOpt()) || commandLine.hasOption(Arguments.DATA_URLENCODE.getOpt()) || commandLine.hasOption(Arguments.FORM.getOpt())) {
            return "POST";
        }
        return "GET";
    }

    private static HttpEntity getForm(CommandLine commandLine) {
        String[] forms = Optional.ofNullable(commandLine.getOptionValues(Arguments.FORM.getOpt())).orElse(new String[0]);
        if (forms.length == 0) {
            return null;
        }
        MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
        Arrays.stream(forms).forEach(arg -> {
            if (arg.indexOf(61) == -1) {
                throw new IllegalArgumentException("option -F: is badly used here");
            }
        });
        List<String> fileForms = Arrays.stream(forms).filter(arg -> IOUtils.isFile(arg.substring(arg.indexOf(61) + 1))).collect(Collectors.toList());
        List<String> textForms = Arrays.stream(forms).filter(form -> !fileForms.contains(form)).collect(Collectors.toList());
        fileForms.forEach(arg -> multiPartBuilder.addPart(arg.substring(0, arg.indexOf(61)), (ContentBody)new FileBody(IOUtils.getFile(arg.substring(arg.indexOf("=@") + 2)))));
        textForms.forEach(arg -> multiPartBuilder.addTextBody(arg.substring(0, arg.indexOf(61)), arg.substring(arg.indexOf(61) + 1)));
        return multiPartBuilder.build();
    }

    private static void setHeaders(CommandLine commandLine, RequestBuilder request) {
        String[] headers = Optional.ofNullable(commandLine.getOptionValues(Arguments.HEADER.getOpt())).orElse(new String[0]);
        Arrays.stream(headers).filter(optionAsString -> optionAsString.indexOf(58) != -1).map(optionAsString -> optionAsString.split(":")).map(optionAsArray -> new BasicHeader(optionAsArray[0].trim().replaceAll("^\"", "").replaceAll("\\\"$", "").replaceAll("^\\'", "").replaceAll("\\'$", ""), String.join((CharSequence)":", Arrays.asList(optionAsArray).subList(1, ((String[])optionAsArray).length)).trim())).forEach(arg_0 -> ((RequestBuilder)request).addHeader(arg_0));
        if (commandLine.hasOption(Arguments.USER_AGENT.getOpt())) {
            request.addHeader("User-Agent", commandLine.getOptionValue(Arguments.USER_AGENT.getOpt()));
        }
        if (request.getFirstHeader(Arguments.USER_AGENT.getOpt()) == null) {
            request.addHeader("User-Agent", Curl.class.getPackage().getName() + "/" + Version.VERSION + VersionInfo.getUserAgent((String)", Apache-HttpClient", (String)"org.apache.http.client", HttpRequestProvider.class));
        }
        if (commandLine.hasOption(Arguments.DATA_URLENCODE.getOpt())) {
            request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        if (commandLine.hasOption(Arguments.NO_KEEPALIVE.getOpt())) {
            request.addHeader("Connection", "Close");
        }
        if (commandLine.hasOption(Arguments.PROXY_USER.getOpt())) {
            request.addHeader("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString(commandLine.getOptionValue(Arguments.PROXY_USER.getOpt()).getBytes()));
        } else if (commandLine.hasOption(Arguments.PROXY.getOpt()) && commandLine.getOptionValue(Arguments.PROXY.getOpt()).contains("@")) {
            request.addHeader("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString(commandLine.getOptionValue(Arguments.PROXY.getOpt()).replaceFirst("^[^/]+/+", "").split("@")[0].getBytes()));
        }
    }

    private static RequestConfig getConfig(CommandLine commandLine) {
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        if (commandLine.hasOption(Arguments.PROXY.getOpt())) {
            String hostWithoutTrailingSlash = commandLine.getOptionValue(Arguments.PROXY.getOpt()).replaceFirst("\\s*/\\s*$", "").replaceFirst("^[^@]+@", "");
            requestConfig.setProxy(HttpHost.create((String)hostWithoutTrailingSlash));
        }
        if (commandLine.hasOption(Arguments.CONNECT_TIMEOUT.getOpt())) {
            requestConfig.setConnectTimeout((int)(Float.parseFloat(commandLine.getOptionValue(Arguments.CONNECT_TIMEOUT.getOpt())) * 1000.0f));
        }
        if (commandLine.hasOption(Arguments.MAX_TIME.getOpt())) {
            requestConfig.setSocketTimeout((int)(Float.parseFloat(commandLine.getOptionValue(Arguments.MAX_TIME.getOpt())) * 1000.0f));
        }
        return requestConfig.build();
    }
}

