/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.http.HttpResponse;
import org.toilelibre.libe.curl.HttpClientProvider;
import org.toilelibre.libe.curl.HttpRequestProvider;
import org.toilelibre.libe.curl.IOUtils;
import org.toilelibre.libe.curl.ReadArguments;

public class Curl {
    public static CurlArgumentsBuilder curl() {
        return new CurlArgumentsBuilder();
    }

    public static String $(String requestCommand) throws CurlException {
        try {
            return IOUtils.toString(Curl.curl(requestCommand).getEntity().getContent());
        }
        catch (IOException e) {
            throw new CurlException(e);
        }
    }

    public static HttpResponse curl(String requestCommand) throws CurlException {
        CommandLine commandLine = ReadArguments.getCommandLineFromRequest(requestCommand);
        try {
            return HttpClientProvider.prepareHttpClient(commandLine).execute(HttpRequestProvider.prepareRequest(commandLine));
        }
        catch (IOException e) {
            throw new CurlException(e);
        }
    }

    public static class CurlArgumentsBuilder {
        private final StringBuilder curlCommand = new StringBuilder("curl ");

        CurlArgumentsBuilder() {
        }

        public HttpResponse run(String url) throws CurlException {
            this.curlCommand.append(url + " ");
            return Curl.curl(this.curlCommand.toString());
        }

        public String $(String url) throws CurlException {
            this.curlCommand.append(url + " ");
            return Curl.$(this.curlCommand.toString());
        }

        public CurlArgumentsBuilder x(String string) {
            this.curlCommand.append(new StringBuffer().append("-X ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder request(String string) {
            this.curlCommand.append(new StringBuffer().append("--request ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder h(String string) {
            this.curlCommand.append(new StringBuffer().append("-H ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder header(String string) {
            this.curlCommand.append(new StringBuffer().append("--header ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder d(String string) {
            this.curlCommand.append(new StringBuffer().append("-d ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder data(String string) {
            this.curlCommand.append(new StringBuffer().append("--data ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder s() {
            this.curlCommand.append("-s ");
            return this;
        }

        public CurlArgumentsBuilder silent() {
            this.curlCommand.append("--silent ");
            return this;
        }

        public CurlArgumentsBuilder k() {
            this.curlCommand.append("-k ");
            return this;
        }

        public CurlArgumentsBuilder insecure() {
            this.curlCommand.append("--insecure ");
            return this;
        }

        public CurlArgumentsBuilder n() {
            this.curlCommand.append("-n ");
            return this;
        }

        public CurlArgumentsBuilder noBuffer() {
            this.curlCommand.append("--no-buffer ");
            return this;
        }

        public CurlArgumentsBuilder ntlm() {
            this.curlCommand.append("--ntlm ");
            return this;
        }

        public CurlArgumentsBuilder u(String string) {
            this.curlCommand.append(new StringBuffer().append("-u ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder username(String string) {
            this.curlCommand.append(new StringBuffer().append("--username ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder key(String string) {
            this.curlCommand.append(new StringBuffer().append("--key ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder kt(String string) {
            this.curlCommand.append(new StringBuffer().append("--kt ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder keyType(String string) {
            this.curlCommand.append(new StringBuffer().append("--key-type ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder cacert(String string) {
            this.curlCommand.append(new StringBuffer().append("--cacert ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder e(String string) {
            this.curlCommand.append(new StringBuffer().append("-E ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder cert(String string) {
            this.curlCommand.append(new StringBuffer().append("--cert ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder ct(String string) {
            this.curlCommand.append(new StringBuffer().append("--ct ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder certType(String string) {
            this.curlCommand.append(new StringBuffer().append("--cert-type ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder l() {
            this.curlCommand.append("-L ");
            return this;
        }

        public CurlArgumentsBuilder location() {
            this.curlCommand.append("--location ");
            return this;
        }

        public CurlArgumentsBuilder a(String string) {
            this.curlCommand.append(new StringBuffer().append("-A ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder userAgent(String string) {
            this.curlCommand.append(new StringBuffer().append("--user-agent ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder f(String string) {
            this.curlCommand.append(new StringBuffer().append("-F ").append(string).append(" ").toString());
            return this;
        }

        public CurlArgumentsBuilder form(String string) {
            this.curlCommand.append(new StringBuffer().append("--form ").append(string).append(" ").toString());
            return this;
        }
    }

    public static class CurlException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CurlException(Throwable arg0) {
            super(arg0);
        }
    }
}

