/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;

class IOUtils {
    static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    IOUtils() {
    }

    private static int copy(Reader input, Writer output) throws IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private static void copy(InputStream input, Writer output, Charset encoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        IOUtils.copy(in, output);
    }

    private static long copyLarge(Reader input, Writer output) throws IOException {
        return IOUtils.copyLarge(input, output, new char[4096]);
    }

    private static long copyLarge(Reader input, Writer output, char[] buffer) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    static String toString(InputStream input) throws IOException {
        return IOUtils.toString(input, Charset.defaultCharset());
    }

    static byte[] toString(File fileObject) throws IOException {
        byte[] result = new byte[(int)fileObject.length()];
        FileInputStream fis = new FileInputStream(fileObject);
        DataInputStream dis = new DataInputStream(fis);
        dis.readFully(result);
        dis.close();
        fis.close();
        return result;
    }

    private static InputStream toStream(String input) throws IOException {
        return IOUtils.toStream(input, Charset.defaultCharset());
    }

    private static InputStream toStream(String input, Charset defaultCharset) {
        return new ByteArrayInputStream(input.getBytes(defaultCharset));
    }

    static InputStream markSupportedStream(InputStream inputStream) throws IOException {
        return IOUtils.toStream(IOUtils.toString(inputStream));
    }

    private static String toString(InputStream input, Charset encoding) throws IOException {
        StringBuilderWriter sw = new StringBuilderWriter();
        IOUtils.copy(input, sw, encoding);
        return sw.toString();
    }

    private static class StringBuilderWriter
    extends Writer
    implements Serializable {
        private static final long serialVersionUID = 8461966367767048539L;
        private final StringBuilder builder = new StringBuilder();

        StringBuilderWriter() {
        }

        @Override
        public Writer append(char value) {
            this.builder.append(value);
            return this;
        }

        @Override
        public Writer append(CharSequence value) {
            this.builder.append(value);
            return this;
        }

        @Override
        public Writer append(CharSequence value, int start, int end) {
            this.builder.append(value, start, end);
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(String value) {
            if (value != null) {
                this.builder.append(value);
            }
        }

        @Override
        public void write(char[] value, int offset, int length) {
            if (value != null) {
                this.builder.append(value, offset, length);
            }
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

