/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.net.URI;
import org.apache.commons.cli.CommandLine;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.toilelibre.libe.curl.Arguments;

final class AuthMethodHandler {
    AuthMethodHandler() {
    }

    static HttpClientBuilder handleAuthMethod(CommandLine commandLine, HttpClientBuilder executor, String hostname) {
        if (commandLine.getOptionValue(Arguments.AUTH.getOpt()) != null) {
            String[] authValue = commandLine.getOptionValue(Arguments.AUTH.getOpt()).split("(?<!\\\\):");
            if (commandLine.hasOption(Arguments.NTLM.getOpt())) {
                String[] userName = authValue[0].split("\\\\");
                SystemDefaultCredentialsProvider systemDefaultCredentialsProvider = new SystemDefaultCredentialsProvider();
                systemDefaultCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(userName[1], authValue[1], hostname, userName[0]));
                return executor.setDefaultCredentialsProvider((CredentialsProvider)systemDefaultCredentialsProvider);
            }
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope(HttpHost.create((String)URI.create(commandLine.getArgs()[0]).getHost())), (Credentials)new UsernamePasswordCredentials(authValue[0], authValue.length > 1 ? authValue[1] : null));
            return executor.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        return executor;
    }
}

