/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.CertFormat;
import org.toilelibre.libe.curl.Curl;
import org.toilelibre.libe.curl.IOUtils;

final class SSLMaterialCreator {
    private static final Map<Map<String, List<String>>, SSLConnectionSocketFactory> cachedSSLFactoriesForPerformance = new HashMap<Map<String, List<String>>, SSLConnectionSocketFactory>();

    SSLMaterialCreator() {
    }

    static void handleSSLParams(CommandLine commandLine, HttpClientBuilder executor) throws Curl.CurlException {
        String entireOption;
        Map<String, List<String>> input = SSLMaterialCreator.inputExtractedFrom(commandLine);
        SSLConnectionSocketFactory foundInCache = cachedSSLFactoriesForPerformance.get(input);
        if (foundInCache != null) {
            executor.setSSLSocketFactory((LayeredConnectionSocketFactory)foundInCache);
            return;
        }
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.setProtocol(SSLMaterialCreator.protocolFromCommandLine(commandLine));
        if (commandLine.hasOption(Arguments.TRUST_INSECURE.getOpt())) {
            SSLMaterialCreator.sayTrustInsecure(builder);
        }
        CertFormat certFormat = commandLine.hasOption(Arguments.CERT_TYPE.getOpt()) ? CertFormat.valueOf(commandLine.getOptionValue(Arguments.CERT_TYPE.getOpt()).toUpperCase()) : CertFormat.PEM;
        CertPlusKeyInfo.Builder certAndKeysBuilder = CertPlusKeyInfo.newBuilder().cacert(commandLine.getOptionValue(Arguments.CA_CERT.getOpt())).certFormat(certFormat).keyFormat(commandLine.hasOption(Arguments.KEY.getOpt()) ? (commandLine.hasOption(Arguments.KEY_TYPE.getOpt()) ? CertFormat.valueOf(commandLine.getOptionValue(Arguments.KEY_TYPE.getOpt()).toUpperCase()) : CertFormat.PEM) : certFormat);
        if (commandLine.hasOption(Arguments.CERT.getOpt())) {
            entireOption = commandLine.getOptionValue(Arguments.CERT.getOpt());
            int certSeparatorIndex = SSLMaterialCreator.getSslSeparatorIndex(entireOption);
            String cert = certSeparatorIndex == -1 ? entireOption : entireOption.substring(0, certSeparatorIndex);
            certAndKeysBuilder.cert(cert).certPassphrase(certSeparatorIndex == -1 ? "" : entireOption.substring(certSeparatorIndex + 1)).key(cert);
        }
        if (commandLine.hasOption(Arguments.KEY.getOpt())) {
            entireOption = commandLine.getOptionValue(Arguments.KEY.getOpt());
            int keySeparatorIndex = SSLMaterialCreator.getSslSeparatorIndex(entireOption);
            String key = keySeparatorIndex == -1 ? entireOption : entireOption.substring(0, keySeparatorIndex);
            certAndKeysBuilder.key(key).keyPassphrase(keySeparatorIndex == -1 ? "" : entireOption.substring(keySeparatorIndex + 1));
        }
        if (commandLine.hasOption(Arguments.CERT.getOpt()) || commandLine.hasOption(Arguments.KEY.getOpt())) {
            SSLMaterialCreator.addClientCredentials(builder, certAndKeysBuilder.build());
        }
        try {
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)(commandLine.hasOption(Arguments.TRUST_INSECURE.getOpt()) ? NoopHostnameVerifier.INSTANCE : SSLConnectionSocketFactory.getDefaultHostnameVerifier()));
            cachedSSLFactoriesForPerformance.put(input, sslSocketFactory);
            executor.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static Map<String, List<String>> inputExtractedFrom(CommandLine commandLine) {
        return Stream.of(Arguments.TRUST_INSECURE, Arguments.CERT_TYPE, Arguments.CA_CERT, Arguments.KEY, Arguments.KEY_TYPE, Arguments.CERT, Arguments.TLS_V1, Arguments.TLS_V10, Arguments.TLS_V11, Arguments.TLS_V12, Arguments.SSL_V2, Arguments.SSL_V3).filter(option -> commandLine.getOptionValues(option.getOpt()) != null || commandLine.hasOption(option.getOpt())).collect(Collectors.toMap(Option::getOpt, option -> Arrays.asList(Optional.ofNullable(commandLine.getOptionValues(option.getOpt())).orElse(new String[]{"true"}))));
    }

    private static void addClientCredentials(SSLContextBuilder builder, CertPlusKeyInfo certPlusKeyInfo) throws Curl.CurlException {
        try {
            String keyPassword = certPlusKeyInfo.getKeyPassphrase() == null ? certPlusKeyInfo.getCertPassphrase() : certPlusKeyInfo.getKeyPassphrase();
            KeyStore keyStore = SSLMaterialCreator.generateKeyStore(certPlusKeyInfo);
            builder.loadKeyMaterial(keyStore, keyPassword == null ? null : keyPassword.toCharArray());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static KeyStore generateKeyStore(CertPlusKeyInfo certPlusKeyInfo) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, Curl.CurlException {
        CertFormat certFormat = certPlusKeyInfo.getCertFormat();
        File caCertFileObject = certPlusKeyInfo.getCacert() == null ? null : IOUtils.getFile(certPlusKeyInfo.getCacert());
        File certFileObject = IOUtils.getFile(certPlusKeyInfo.getCert());
        CertFormat keyFormat = certPlusKeyInfo.getKeyFormat();
        File keyFileObject = IOUtils.getFile(certPlusKeyInfo.getKey());
        char[] certPasswordAsCharArray = certPlusKeyInfo.getCertPassphrase() == null ? null : certPlusKeyInfo.getCertPassphrase().toCharArray();
        char[] keyPasswordAsCharArray = certPlusKeyInfo.getKeyPassphrase() == null ? certPasswordAsCharArray : certPlusKeyInfo.getKeyPassphrase().toCharArray();
        List caCertificatesNotFiltered = caCertFileObject == null ? Collections.emptyList() : certFormat.generateCredentialsFromFileAndPassword(CertFormat.Kind.CERTIFICATE, IOUtils.toByteArray(caCertFileObject), keyPasswordAsCharArray);
        List caCertificatesFiltered = caCertificatesNotFiltered.stream().filter(certificate -> certificate instanceof X509Certificate && ((X509Certificate)certificate).getBasicConstraints() != -1).collect(Collectors.toList());
        List<Certificate> certificates = certFormat.generateCredentialsFromFileAndPassword(CertFormat.Kind.CERTIFICATE, IOUtils.toByteArray(certFileObject), certPasswordAsCharArray);
        List privateKeys = keyFormat.generateCredentialsFromFileAndPassword(CertFormat.Kind.PRIVATE_KEY, IOUtils.toByteArray(keyFileObject), keyPasswordAsCharArray);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null);
        Certificate[] certificatesAsArray = certificates.toArray(new Certificate[0]);
        IntStream.range(0, certificates.size()).forEach(i -> SSLMaterialCreator.setCertificateEntry(keyStore, certificates, i));
        IntStream.range(0, caCertificatesFiltered.size()).forEach(i -> SSLMaterialCreator.setCaCertificateEntry(keyStore, caCertificatesFiltered, i));
        IntStream.range(0, privateKeys.size()).forEach(i -> SSLMaterialCreator.setPrivateKeyEntry(keyStore, privateKeys, keyPasswordAsCharArray, certificatesAsArray, i));
        return keyStore;
    }

    private static int getSslSeparatorIndex(String entireOption) {
        return entireOption.matches("^[A-Za-z]:\\\\") && entireOption.lastIndexOf(58) == 1 ? -1 : entireOption.lastIndexOf(58);
    }

    private static String protocolFromCommandLine(CommandLine commandLine) {
        if (commandLine.hasOption(Arguments.TLS_V1.getOpt())) {
            return "TLSv1";
        }
        if (commandLine.hasOption(Arguments.TLS_V10.getOpt())) {
            return "TLSv1.0";
        }
        if (commandLine.hasOption(Arguments.TLS_V11.getOpt())) {
            return "TLSv1.1";
        }
        if (commandLine.hasOption(Arguments.TLS_V12.getOpt())) {
            return "TLSv1.2";
        }
        if (commandLine.hasOption(Arguments.SSL_V2.getOpt())) {
            return "SSLv2";
        }
        if (commandLine.hasOption(Arguments.SSL_V3.getOpt())) {
            return "SSLv3";
        }
        return "TLS";
    }

    private static void sayTrustInsecure(SSLContextBuilder builder) throws Curl.CurlException {
        try {
            builder.loadTrustMaterial(null, (chain, authType) -> true);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static void setCaCertificateEntry(KeyStore keyStore, List<Certificate> certificates, int i) {
        try {
            keyStore.setCertificateEntry("ca-cert-alias-" + i, certificates.get(i));
        }
        catch (KeyStoreException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static void setCertificateEntry(KeyStore keyStore, List<Certificate> certificates, int i) {
        try {
            keyStore.setCertificateEntry("cert-alias-" + i, certificates.get(i));
        }
        catch (KeyStoreException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static void setPrivateKeyEntry(KeyStore keyStore, List<PrivateKey> privateKeys, char[] passwordAsCharArray, Certificate[] certificatesAsArray, int i) {
        try {
            keyStore.setKeyEntry("key-alias-" + i, privateKeys.get(i), passwordAsCharArray, certificatesAsArray);
        }
        catch (KeyStoreException e) {
            throw new Curl.CurlException(e);
        }
    }

    static class CertPlusKeyInfo {
        private final CertFormat certFormat;
        private final CertFormat keyFormat;
        private final String cert;
        private final String certPassphrase;
        private final String cacert;
        private final String key;
        private final String keyPassphrase;

        private CertPlusKeyInfo(Builder builder) {
            this.certFormat = builder.certFormat;
            this.keyFormat = builder.keyFormat;
            this.cert = builder.cert;
            this.certPassphrase = builder.certPassphrase;
            this.cacert = builder.cacert;
            this.key = builder.key;
            this.keyPassphrase = builder.keyPassphrase;
        }

        static Builder newBuilder() {
            return new Builder();
        }

        CertFormat getCertFormat() {
            return this.certFormat;
        }

        CertFormat getKeyFormat() {
            return this.keyFormat;
        }

        String getCert() {
            return this.cert;
        }

        String getCertPassphrase() {
            return this.certPassphrase;
        }

        String getCacert() {
            return this.cacert;
        }

        String getKey() {
            return this.key;
        }

        String getKeyPassphrase() {
            return this.keyPassphrase;
        }

        static final class Builder {
            private CertFormat certFormat;
            private CertFormat keyFormat;
            private String cert;
            private String certPassphrase;
            private String cacert;
            private String key;
            private String keyPassphrase;

            private Builder() {
            }

            Builder certFormat(CertFormat val) {
                this.certFormat = val;
                return this;
            }

            Builder keyFormat(CertFormat val) {
                this.keyFormat = val;
                return this;
            }

            Builder cert(String val) {
                this.cert = val;
                return this;
            }

            Builder certPassphrase(String val) {
                this.certPassphrase = val;
                return this;
            }

            Builder cacert(String val) {
                this.cacert = val;
                return this;
            }

            Builder key(String val) {
                this.key = val;
                return this;
            }

            Builder keyPassphrase(String val) {
                this.keyPassphrase = val;
                return this;
            }

            CertPlusKeyInfo build() {
                return new CertPlusKeyInfo(this);
            }
        }
    }
}

