/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.Curl;
import org.toilelibre.libe.curl.IOUtils;

final class AfterResponse {
    private static Logger LOGGER = Logger.getLogger(AfterResponse.class.getName());

    AfterResponse() {
    }

    static void handle(CommandLine commandLine, HttpResponse response) {
        if (!commandLine.hasOption(Arguments.OUTPUT.getOpt())) {
            return;
        }
        File file = AfterResponse.createTheOutputFile(commandLine.getOptionValue(Arguments.OUTPUT.getOpt()));
        FileOutputStream outputStream = AfterResponse.getOutputStreamFromFile(file);
        AfterResponse.writeTheResponseEntityInsideStream(outputStream, ((ClassicHttpResponse)response).getEntity());
    }

    private static void writeTheResponseEntityInsideStream(FileOutputStream outputStream, HttpEntity httpEntity) {
        try {
            if (httpEntity.getContentLength() >= 0L) {
                outputStream.write(IOUtils.toByteArray(httpEntity.getContent(), (int)httpEntity.getContentLength()));
            } else {
                outputStream.write(IOUtils.toByteArray(httpEntity.getContent()));
            }
        }
        catch (IOException e) {
            throw new Curl.CurlException(e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Cannot flush the file in output");
            }
        }
    }

    private static FileOutputStream getOutputStreamFromFile(File file) {
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static File createTheOutputFile(String fileName) {
        File file = new File(fileName);
        try {
            if (!file.createNewFile()) {
                throw new Curl.CurlException(new IOException("Could not create the file. Does it already exist ?"));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Cannot flush the output file");
            throw new Curl.CurlException(e);
        }
        return file;
    }
}

