/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.Curl;

final class InterceptorsBinder {
    private static final BiFunction<HttpRequest, Supplier<ClassicHttpResponse>, ClassicHttpResponse> EXAMPLE = (request, responseSupplier) -> (ClassicHttpResponse)responseSupplier.get();
    private static Type EXAMPLE_TYPE;

    InterceptorsBinder() {
    }

    static void handleInterceptors(CommandLine commandLine, HttpClientBuilder executor, List<BiFunction<HttpRequest, Supplier<ClassicHttpResponse>, ClassicHttpResponse>> additionalInterceptors) {
        final List interceptors = Stream.concat(Arrays.stream(Optional.ofNullable(commandLine.getOptionValues(Arguments.INTERCEPTOR.getOpt())).orElse(new String[0])).map(methodName -> {
            Object newInstance;
            Class<?> targetClass;
            try {
                targetClass = Class.forName(methodName.split("::")[0]);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            try {
                newInstance = targetClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                newInstance = null;
            }
            Object finalNewInstance = newInstance;
            try {
                BiFunction candidate = Arrays.stream(targetClass.getDeclaredFields()).filter(f -> EXAMPLE_TYPE.equals(f.getGenericType())).findFirst().map(f -> {
                    try {
                        f.setAccessible(true);
                        return (BiFunction)f.get(finalNewInstance);
                    }
                    catch (IllegalAccessException e) {
                        return null;
                    }
                }).orElse(null);
                if (candidate != null) {
                    return candidate;
                }
                Method targetMethod = Arrays.stream(targetClass.getDeclaredMethods()).filter(m -> methodName.split("::")[1].equals(m.getName())).findFirst().orElse(null);
                if (targetMethod == null) {
                    return null;
                }
                return (request, subsequentCall) -> {
                    try {
                        return (ClassicHttpResponse)targetMethod.invoke(finalNewInstance, request, subsequentCall);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new Curl.CurlException(e);
                    }
                };
            }
            catch (ClassCastException e) {
                return null;
            }
        }).filter(Objects::nonNull), additionalInterceptors.stream()).collect(Collectors.toList());
        executor.setRequestExecutor(new HttpRequestExecutor(){

            public ClassicHttpResponse execute(ClassicHttpRequest request, HttpClientConnection connection, HttpContext context) {
                Supplier<ClassicHttpResponse> executor = () -> {
                    try {
                        return super.execute(request, connection, context);
                    }
                    catch (IOException | HttpException e) {
                        throw new Curl.CurlException(e);
                    }
                };
                return this.loop((HttpRequest)request, executor, interceptors);
            }

            ClassicHttpResponse loop(HttpRequest request, Supplier<ClassicHttpResponse> realCall, List<BiFunction<HttpRequest, Supplier<ClassicHttpResponse>, ClassicHttpResponse>> remainingInterceptors) {
                if (remainingInterceptors.size() > 0) {
                    BiFunction<HttpRequest, Supplier<ClassicHttpResponse>, ClassicHttpResponse> nextInterceptor = remainingInterceptors.get(0);
                    return nextInterceptor.apply(request, () -> this.loop(request, realCall, remainingInterceptors.subList(1, remainingInterceptors.size())));
                }
                return realCall.get();
            }
        });
    }

    static {
        try {
            EXAMPLE_TYPE = InterceptorsBinder.class.getDeclaredField("EXAMPLE").getGenericType();
        }
        catch (NoSuchFieldException e) {
            throw new Curl.CurlException(new IllegalArgumentException(e));
        }
    }
}

