/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.cli.CommandLine;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.SystemDefaultCredentialsProvider;
import org.apache.hc.core5.http.HttpHost;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.Curl;
import org.toilelibre.libe.curl.HttpClientBuilder;

final class AuthMethodHandler {
    private static final AuthScope ANY = new AuthScope(null, null, -1, null, null);

    AuthMethodHandler() {
    }

    static HttpClientBuilder handleAuthMethod(CommandLine commandLine, HttpClientBuilder executor, String hostname) {
        if (commandLine.getOptionValue(Arguments.AUTH.getOpt()) != null) {
            String[] authValue = commandLine.getOptionValue(Arguments.AUTH.getOpt()).split("(?<!\\\\):");
            if (commandLine.hasOption(Arguments.NTLM.getOpt())) {
                String[] userName = authValue[0].split("\\\\");
                SystemDefaultCredentialsProvider systemDefaultCredentialsProvider = new SystemDefaultCredentialsProvider();
                systemDefaultCredentialsProvider.setCredentials(ANY, (Credentials)new NTCredentials(userName[1], authValue[1].toCharArray(), hostname, userName[0]));
                return (HttpClientBuilder)executor.setDefaultCredentialsProvider((CredentialsProvider)systemDefaultCredentialsProvider);
            }
            try {
                BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                URI targetUri = URI.create(commandLine.getArgs()[0]);
                basicCredentialsProvider.setCredentials(new AuthScope(HttpHost.create((String)(targetUri.toURL().getProtocol() + "://" + targetUri.getAuthority()))), (Credentials)new UsernamePasswordCredentials(authValue[0], authValue.length > 1 ? authValue[1].toCharArray() : null));
                return (HttpClientBuilder)executor.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new Curl.CurlException(e);
            }
        }
        return executor;
    }
}

