/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.Curl;

final class ReadArguments {
    private static final Pattern PLACEHOLDER_REGEX = Pattern.compile("^\\$curl_placeholder_[0-9]+$");
    private static final Map<String, List<String>> CACHED_ARGS_MATCHES = new HashMap<String, List<String>>();

    ReadArguments() {
    }

    static CommandLine getCommandLineFromRequest(String requestCommand, List<String> placeholderValues) {
        return ReadArguments.getCommandLineFromRequest(requestCommand, placeholderValues, CACHED_ARGS_MATCHES);
    }

    static CommandLine getCommandLineFromRequest(String requestCommand, List<String> placeholderValues, Map<String, List<String>> argMatches) {
        CommandLine commandLine;
        DefaultParser parser = new DefaultParser();
        String requestCommandWithoutBasename = requestCommand.replaceAll("^[ ]*curl[ ]*", " ") + " ";
        String[] args = ReadArguments.getArgsFromCommand(requestCommandWithoutBasename, placeholderValues, argMatches);
        try {
            commandLine = parser.parse(Arguments.ALL_OPTIONS, args);
        }
        catch (ParseException e) {
            new HelpFormatter().printHelp("curl [options] url", Arguments.ALL_OPTIONS);
            throw new Curl.CurlException(e);
        }
        return commandLine;
    }

    private static List<String> asMatches(Pattern regex, String input) {
        Matcher matcher = regex.matcher(input);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    private static String[] getArgsFromCommand(String requestCommandWithoutBasename, List<String> placeholderValues, Map<String, List<String>> argMatches) {
        List<String> matches;
        String requestCommandInput = requestCommandWithoutBasename.replaceAll("\\s+-([a-zA-Z0-9])\\s+", " -$1 ");
        if (argMatches.containsKey(requestCommandInput)) {
            matches = argMatches.get(requestCommandInput);
        } else {
            matches = ReadArguments.asMatches(Arguments.ARGS_SPLIT_REGEX, requestCommandInput);
            argMatches.put(requestCommandInput, matches);
        }
        return (String[])Optional.ofNullable(matches).map(Collection::stream).orElse(Stream.empty()).map(match -> {
            String argument = ReadArguments.removeSlashes(match.trim());
            if (PLACEHOLDER_REGEX.matcher(argument).matches()) {
                return (String)placeholderValues.get(Integer.parseInt(argument.substring("$curl_placeholder_".length())));
            }
            return argument;
        }).toArray(String[]::new);
    }

    private static String removeSlashes(String arg) {
        if (arg.length() == 0) {
            return arg;
        }
        if (arg.charAt(0) == '\"') {
            return arg.substring(1, arg.length() - 1).replaceAll("\\\"", "\"");
        }
        if (arg.charAt(0) == '\'') {
            return arg.substring(1, arg.length() - 1).replaceAll("\\'", "'");
        }
        return arg;
    }
}

