/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.AuthMethodHandler;
import org.toilelibre.libe.curl.Curl;
import org.toilelibre.libe.curl.HttpClientBuilder;
import org.toilelibre.libe.curl.HttpRequestProvider;
import org.toilelibre.libe.curl.InterceptorsBinder;
import org.toilelibre.libe.curl.SSLMaterialCreator;

final class HttpClientProvider {
    HttpClientProvider() {
    }

    static HttpClient prepareHttpClient(CommandLine commandLine, List<BiFunction<HttpRequest, Supplier<ClassicHttpResponse>, ClassicHttpResponse>> additionalInterceptors, HttpClientConnectionManager connectionManager, Consumer<org.apache.hc.client5.http.impl.classic.HttpClientBuilder> httpClientCustomizer, Consumer<HttpContext> contextTester) throws Curl.CurlException {
        String hostname;
        HttpClientBuilder executor = HttpClientBuilder.create();
        if (httpClientCustomizer != null) {
            httpClientCustomizer.accept(executor);
        }
        if (!commandLine.hasOption(Arguments.COMPRESSED.getOpt())) {
            executor.disableContentCompression();
        }
        HttpClientConnectionManager chosenConnectionManager = connectionManager != null ? connectionManager : PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)SSLMaterialCreator.buildConnectionFactory(commandLine)).setConnectionConfigResolver(route -> HttpRequestProvider.getConnectionConfig(commandLine)).build();
        executor.setConnectionManager(chosenConnectionManager);
        executor.setRoutePlanner(HttpRequestProvider.getRoutePlanner(commandLine));
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e1) {
            throw new Curl.CurlException(e1);
        }
        executor = AuthMethodHandler.handleAuthMethod(commandLine, executor, hostname);
        if (!commandLine.hasOption(Arguments.FOLLOW_REDIRECTS.getOpt())) {
            executor.disableRedirectHandling();
        }
        InterceptorsBinder.handleInterceptors(commandLine, executor, additionalInterceptors);
        executor.setContextTester(contextTester);
        return executor.build();
    }
}

