/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.Curl;
import org.toilelibre.libe.curl.IOUtils;

final class PayloadReader {
    private static final Pattern CONTENT_TYPE_ENCODING = Pattern.compile("\\s*content-type\\s*:[^;]+;\\s*charset\\s*=\\s*(.*)", 2);

    PayloadReader() {
    }

    static AbstractHttpEntity getData(CommandLine commandLine) {
        if (commandLine.hasOption(Arguments.DATA.getOpt())) {
            return PayloadReader.simpleDataFrom(commandLine);
        }
        if (commandLine.hasOption(Arguments.DATA_BINARY.getOpt())) {
            return PayloadReader.binaryDataFrom(commandLine);
        }
        if (commandLine.hasOption(Arguments.DATA_URLENCODE.getOpt())) {
            return new StringEntity(Arrays.stream(commandLine.getOptionValues(Arguments.DATA_URLENCODE.getOpt())).map(PayloadReader::urlEncodedDataFrom).collect(Collectors.joining("&")));
        }
        return null;
    }

    private static StringEntity simpleDataFrom(CommandLine commandLine) {
        try {
            Charset encoding = PayloadReader.charsetReadFromThe(commandLine).orElse(StandardCharsets.UTF_8);
            return new StringEntity(commandLine.getOptionValue(Arguments.DATA.getOpt()), encoding);
        }
        catch (IllegalArgumentException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static InputStreamEntity binaryDataFrom(CommandLine commandLine) {
        String value = commandLine.getOptionValue(Arguments.DATA_BINARY.getOpt());
        if (value.indexOf(64) == 0) {
            return new InputStreamEntity((InputStream)new ByteArrayInputStream(IOUtils.dataBehind(value)), ContentType.APPLICATION_OCTET_STREAM);
        }
        return new InputStreamEntity((InputStream)new ByteArrayInputStream(value.getBytes()), ContentType.APPLICATION_OCTET_STREAM);
    }

    private static Optional<Charset> charsetReadFromThe(CommandLine commandLine) {
        return Arrays.stream(Optional.ofNullable(commandLine.getOptionValues(Arguments.HEADER.getOpt())).orElse(new String[0])).filter(header -> header != null && CONTENT_TYPE_ENCODING.asPredicate().test((String)header)).findFirst().map(correctHeader -> {
            Matcher matcher = CONTENT_TYPE_ENCODING.matcher((CharSequence)correctHeader);
            if (!matcher.find()) {
                return null;
            }
            return Charset.forName(matcher.group(1));
        });
    }

    private static String urlEncodedDataFrom(String value) {
        if (value.startsWith("=")) {
            value = value.substring(1);
        }
        if (value.indexOf(61) != -1) {
            return value.substring(0, value.indexOf(61) + 1) + PayloadReader.encodeOrFail(value.substring(value.indexOf(61) + 1), Charset.defaultCharset());
        }
        if (value.indexOf(64) == 0) {
            return PayloadReader.encodeOrFail(new String(IOUtils.dataBehind(value)), Charset.defaultCharset());
        }
        if (value.indexOf(64) != -1) {
            return value.substring(0, value.indexOf(64)) + '=' + PayloadReader.encodeOrFail(new String(IOUtils.dataBehind(value.substring(value.indexOf(64)))), Charset.defaultCharset());
        }
        return PayloadReader.encodeOrFail(value, Charset.defaultCharset());
    }

    private static String encodeOrFail(String value, Charset encoding) {
        try {
            return URLEncoder.encode(value, encoding.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new Curl.CurlException(e);
        }
    }
}

