/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

final class Arguments {
    static final Options ALL_OPTIONS = new Options();
    static final String ARGS_SPLIT_REGEX = "([^'\"][^ ]*|(?:\"(?:[^\"]|\\\\\")+\")|(?:'(?:[^']|[^ ]+')+'))\\s+";
    static final Option AUTH = Arguments.add(Option.builder((String)"u").longOpt("username").desc("credentials").required(false).hasArg(true).desc("user:password").build());
    static final Option CA_CERT = Arguments.add(Option.builder((String)"cacert").longOpt("cacert").desc("CA certificate").required(false).hasArg(true).desc("CA_CERT").build());
    static final Option CERT = Arguments.add(Option.builder((String)"E").longOpt("cert").desc("client certificate").required(false).hasArg(true).desc("CERT[:password]").build());
    static final Option CERT_TYPE = Arguments.add(Option.builder((String)"ct").longOpt("cert-type").desc("certificate type").required(false).hasArg(true).desc("PEM|P12|JKS|DER|ENG").build());
    static final Option DATA = Arguments.add(Option.builder((String)"d").longOpt("data").desc("Data").required(false).hasArg().argName("payload").build());
    static final Option FOLLOW_REDIRECTS = Arguments.add(Option.builder((String)"L").longOpt("location").desc("follow redirects").required(false).hasArg(false).build());
    static final Option FORM = Arguments.add(Option.builder((String)"F").longOpt("form").desc("http multipart post data").required(false).hasArg(true).build());
    static final Option HEADER = Arguments.add(Option.builder((String)"H").longOpt("header").desc("Header").required(false).hasArg().argName("headerValue").build());
    static final Option HTTP_METHOD = Arguments.add(Option.builder((String)"X").longOpt("request").desc("Http Method").required(false).hasArg().argName("method").build());
    static final Option KEY = Arguments.add(Option.builder((String)"key").longOpt("key").desc("key").required(false).hasArg(true).desc("KEY").build());
    static final Option KEY_TYPE = Arguments.add(Option.builder((String)"kt").longOpt("key-type").desc("key type").required(false).hasArg(true).desc("PEM|P12|JKS|DER|ENG").build());
    static final Option NO_BUFFERING = Arguments.add(Option.builder((String)"n").longOpt("no-buffer").desc("no buffering").required(false).hasArg(false).build());
    static final Option NTLM = Arguments.add(Option.builder((String)"ntlm").longOpt("ntlm").desc("NTLM auth").required(false).hasArg(false).build());
    static final Option SILENT = Arguments.add(Option.builder((String)"s").longOpt("silent").desc("silent").required(false).hasArg(false).build());
    static final Option TLS_V1 = Arguments.add(Option.builder((String)"1").longOpt("tlsv1").desc("use >= TLSv1 (SSL)").required(false).hasArg(false).build());
    static final Option TLS_V10 = Arguments.add(Option.builder((String)"tlsv10").longOpt("tlsv1.0").desc("use TLSv1.0 (SSL)").required(false).hasArg(false).build());
    static final Option TLS_V11 = Arguments.add(Option.builder((String)"tlsv11").longOpt("tlsv1.1").desc("use TLSv1.1 (SSL)").required(false).hasArg(false).build());
    static final Option TLS_V12 = Arguments.add(Option.builder((String)"tlsv12").longOpt("tlsv1.2").desc("use TLSv1.2 (SSL)").required(false).hasArg(false).build());
    static final Option SSL_V2 = Arguments.add(Option.builder((String)"2").longOpt("sslv2").desc("use SSLv2 (SSL)").required(false).hasArg(false).build());
    static final Option SSL_V3 = Arguments.add(Option.builder((String)"3").longOpt("sslv3").desc("use SSLv3 (SSL)").required(false).hasArg(false).build());
    static final Option TRUST_INSECURE = Arguments.add(Option.builder((String)"k").longOpt("insecure").desc("trust insecure").required(false).hasArg(false).build());
    static final Option USER_AGENT = Arguments.add(Option.builder((String)"A").longOpt("user-agent").desc("user agent").required(false).hasArg(true).build());

    Arguments() {
    }

    private static Option add(Option option) {
        ALL_OPTIONS.addOption(option);
        return option;
    }
}

