/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.toilelibre.libe.curl.Curl;
import org.toilelibre.libe.curl.DerReader;
import org.toilelibre.libe.curl.PemReader;

enum CertFormat {
    DER((kind, content, passwordAsCharArray) -> {
        try {
            if (kind == Kind.CERTIFICATE) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                return Arrays.asList(certificateFactory.generateCertificate(new ByteArrayInputStream(content)));
            }
            if (kind == Kind.PRIVATE_KEY) {
                DerReader derReader = new DerReader(content);
                DerReader.Asn1Object asn1 = derReader.read();
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                KeySpec keySpec = asn1.getKeySpec();
                return Arrays.asList(keyFactory.generatePrivate(keySpec));
            }
            return null;
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            throw new Curl.CurlException(e);
        }
    }),
    ENG((content, kind, passwordAsCharArray) -> {
        try {
            return KeyStore.getInstance("pkcs12");
        }
        catch (KeyStoreException e) {
            throw new Curl.CurlException(e);
        }
    }),
    JKS((kind, content, passwordAsCharArray) -> {
        try {
            return CertFormat.readFromKeystoreType("jks", content, kind, passwordAsCharArray);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new Curl.CurlException(e);
        }
    }),
    P12((kind, content, passwordAsCharArray) -> {
        try {
            return CertFormat.readFromKeystoreType("pkcs12", content, kind, passwordAsCharArray);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new Curl.CurlException(e);
        }
    }),
    PEM((kind, content, passwordAsCharArray) -> {
        BufferedReader pemReader = null;
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        try {
            PemReader.PemObject pemObject;
            pemReader = new PemReader(new InputStreamReader(new ByteArrayInputStream(content)));
            PKCS8EncodedKeySpec privateKeySpec = null;
            while ((pemObject = ((PemReader)pemReader).readPemObject()) != null) {
                Kind readKind = Kind.fromValue(pemObject.getType());
                if (kind != readKind) continue;
                switch (kind) {
                    case PRIVATE_KEY: {
                        privateKeySpec = new PKCS8EncodedKeySpec(pemObject.getContent());
                        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                        result.add(keyFactory.generatePrivate(privateKeySpec));
                        break;
                    }
                    case CERTIFICATE: {
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        result.add(certificateFactory.generateCertificate(new ByteArrayInputStream(pemObject.getContent())));
                        break;
                    }
                }
            }
            ArrayList<Serializable> arrayList = result;
            return arrayList;
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            throw new Curl.CurlException(e);
        }
        finally {
            if (pemReader != null) {
                try {
                    pemReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    });

    private KeystoreFromFileGenerator generator;

    private CertFormat(KeystoreFromFileGenerator generator1) {
        this.generator = generator1;
    }

    public <T> List<T> generateCredentialsFromFileAndPassword(Kind kind, byte[] content, char[] passwordAsCharArray) {
        return (List)this.generator.generate(kind, content, passwordAsCharArray);
    }

    public KeystoreFromFileGenerator getGenerator() {
        return this.generator;
    }

    private static List<Object> readFromKeystoreType(String type, byte[] content, Kind kind, char[] passwordAsCharArray) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(new ByteArrayInputStream(content), passwordAsCharArray);
        Enumeration<String> aliases = keyStore.aliases();
        ArrayList<Object> result = new ArrayList<Object>();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (keyStore.getCertificate(alias) != null && kind == Kind.CERTIFICATE) {
                result.add(keyStore.getCertificate(alias));
            }
            if (keyStore.getKey(alias, passwordAsCharArray) == null || kind != Kind.PRIVATE_KEY) continue;
            result.add(keyStore.getKey(alias, passwordAsCharArray));
        }
        return result;
    }

    static enum Kind {
        CERTIFICATE,
        CERTIFICATE_WITH_CACERT,
        PRIVATE_KEY;


        static Kind fromValue(String value) {
            try {
                return Kind.valueOf(value.toUpperCase().replace(' ', '_'));
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
    }

    @FunctionalInterface
    static interface KeystoreFromFileGenerator {
        public Object generate(Kind var1, byte[] var2, char[] var3);
    }
}

