/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.http.HttpResponse;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.Curl;
import org.toilelibre.libe.curl.IOUtils;

class AfterResponse {
    AfterResponse() {
    }

    static void handle(CommandLine commandLine, HttpResponse response) {
        if (commandLine.hasOption(Arguments.OUTPUT.getOpt())) {
            FileOutputStream outputStream;
            File file = new File(commandLine.getOptionValue(Arguments.OUTPUT.getOpt()));
            try {
                outputStream = new FileOutputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new Curl.CurlException(e);
            }
            try {
                outputStream.write(IOUtils.toByteArray(response.getEntity().getContent(), (int)response.getEntity().getContentLength()));
            }
            catch (IOException e) {
                throw new Curl.CurlException(e);
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new Curl.CurlException(e);
                }
            }
        }
    }
}

