/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.converters;

import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.tomitribe.crest.cmds.processors.types.PrimitiveTypes;
import org.tomitribe.util.editor.Editors;

public class Converter {
    private Converter() {
    }

    public static Object convert(Object value, Class<?> targetType, String name) {
        Object result;
        if (value == null) {
            if (targetType.equals(Boolean.TYPE)) {
                return false;
            }
            return value;
        }
        Class<?> actualType = value.getClass();
        if (targetType.isPrimitive()) {
            targetType = PrimitiveTypes.valueOf(targetType.toString().toUpperCase()).getWraper();
        }
        if (targetType.isAssignableFrom(actualType)) {
            return value;
        }
        if (Number.class.isAssignableFrom(actualType) && Number.class.isAssignableFrom(targetType)) {
            return value;
        }
        if (!(value instanceof String)) {
            String message = String.format("Expected type '%s' for '%s'. Found '%s'", targetType.getName(), name, actualType.getName());
            throw new IllegalArgumentException(message);
        }
        String stringValue = (String)value;
        if (Enum.class.isAssignableFrom(targetType)) {
            Class<?> enumType = targetType;
            try {
                return Enum.valueOf(enumType, stringValue);
            }
            catch (IllegalArgumentException e) {
                try {
                    return Enum.valueOf(enumType, stringValue.toUpperCase());
                }
                catch (IllegalArgumentException e1) {
                    return Enum.valueOf(enumType, stringValue.toLowerCase());
                }
            }
        }
        try {
            Class.forName(targetType.getName(), true, targetType.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        PropertyEditor editor = Editors.get(targetType);
        if (editor == null && (result = Converter.create(targetType, stringValue)) != null) {
            return result;
        }
        if (editor == null) {
            String message = String.format("Cannot convert to '%s' for '%s'. No PropertyEditor", targetType.getName(), name);
            throw new IllegalArgumentException(message);
        }
        editor.setAsText(stringValue);
        return editor.getValue();
    }

    private static Object create(Class<?> type, String value) {
        try {
            Constructor<?> constructor = type.getConstructor(String.class);
            return constructor.newInstance(value);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            String message = String.format("Cannot convert string '%s' to %s.", value, type);
            throw new IllegalArgumentException(message, e);
        }
        for (Method method : type.getMethods()) {
            if (Converter.isInvalidMethod(type, method)) continue;
            try {
                return method.invoke(null, value);
            }
            catch (Exception e) {
                String message = String.format("Cannot convert string '%s' to %s.", value, type);
                throw new IllegalStateException(message, e);
            }
        }
        return null;
    }

    private static boolean isInvalidMethod(Class<?> type, Method method) {
        return !Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || !method.getReturnType().equals(type) || !method.getParameterTypes()[0].equals(String.class) || method.getParameterTypes().length != 1;
    }
}

