/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.val;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.tomitribe.crest.val.BVal05;
import org.tomitribe.crest.val.BeanValidation11;

public class BeanValidation {
    private static final BeanValidationImpl IMPL;

    private BeanValidation() {
    }

    public static boolean isActive() {
        return IMPL != null;
    }

    public static void validateParameters(Object instance, Method method, Object[] parameters) throws Exception {
        if (!BeanValidation.isActive()) {
            return;
        }
        IMPL.validateParameters(instance, method, parameters);
    }

    public static void validateParameters(Constructor constructor, Object[] parameters) throws Exception {
        if (!BeanValidation.isActive()) {
            return;
        }
        IMPL.validateParameters(constructor, parameters);
    }

    public static Iterable<? extends String> messages(Exception e) {
        if (!ConstraintViolationException.class.isInstance(e)) {
            return Collections.singletonList(e.getMessage());
        }
        LinkedList<String> msg = new LinkedList<String>();
        ConstraintViolationException cve = (ConstraintViolationException)e;
        for (ConstraintViolation violation : cve.getConstraintViolations()) {
            msg.add(violation.getMessage());
        }
        return msg;
    }

    static {
        BeanValidationImpl impl = null;
        ClassLoader loader = BeanValidation.class.getClassLoader();
        try {
            Class.forName("javax.validation.executable.ExecutableValidator", false, loader);
            impl = new BeanValidation11();
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("org.apache.bval.jsr303.extensions.MethodValidator", false, loader);
                impl = new BVal05();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        IMPL = impl;
    }

    public static interface BeanValidationImpl {
        public void validateParameters(Object var1, Method var2, Object[] var3);

        public void validateParameters(Constructor var1, Object[] var2);
    }
}

