/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.tomitribe.crest.help.Bullet;
import org.tomitribe.crest.help.Document;
import org.tomitribe.crest.help.Element;
import org.tomitribe.crest.help.Heading;
import org.tomitribe.crest.help.Highlight;
import org.tomitribe.crest.help.Justify;
import org.tomitribe.crest.help.Option;
import org.tomitribe.crest.help.Paragraph;
import org.tomitribe.crest.help.Preformatted;
import org.tomitribe.crest.help.Wrap;
import org.tomitribe.util.PrintString;
import org.tomitribe.util.Strings;

public class DocumentFormatter {
    private final String margin = "       ";
    private final int width;
    private final int column;
    private final boolean color;

    public DocumentFormatter(int width) {
        this(width, true);
    }

    public DocumentFormatter(int width, boolean color) {
        this.width = width;
        this.column = width - "       ".length() - "       ".length();
        this.color = color;
    }

    public String format(Document document) {
        Function<String, String> highlight;
        PrintString out = new PrintString();
        Highlight highlighter = new Highlight(DocumentFormatter.getOptions(document));
        Function<String, String> function = this.color ? highlighter::highlight : (highlight = Function.identity());
        Function<String, String> highlightKeywords = this.color ? highlighter::matches : Function.identity();
        Iterator<Element> iterator = document.getElements().iterator();
        while (iterator.hasNext()) {
            String content;
            Element element = iterator.next();
            if (element instanceof Heading) {
                Heading heading = (Heading)element;
                String text = Strings.uppercase((String)heading.getContent());
                out.println((String)highlight.apply(text));
                continue;
            }
            if (element instanceof Paragraph) {
                Paragraph paragraph = (Paragraph)element;
                content = Justify.wrapAndJustify(paragraph.getContent() + "", this.column);
                Stream.of(content.split("\n")).map(highlightKeywords).forEach(s -> out.format("%s%s%n", new Object[]{"       ", s}));
                if (!iterator.hasNext()) continue;
                out.println();
                continue;
            }
            if (element instanceof Option) {
                Option option = (Option)element;
                DocumentFormatter formatter = new DocumentFormatter(this.width - "       ".length(), false);
                String content2 = formatter.format(option.getDocument());
                ArrayList<String> lines = content2 == null || content2.length() == 0 ? Collections.EMPTY_LIST : new ArrayList<String>(Arrays.asList(content2.split("\n")));
                if (option.getFlag().length() < 7 && lines.size() > 0) {
                    String firstLine = ((String)lines.remove(0)).trim();
                    if (this.color) {
                        out.format("%s\u001b[0m\u001b[1m%-6s\u001b[0m %s%n", new Object[]{"       ", option.getFlag(), highlightKeywords.apply(firstLine)});
                    } else {
                        out.format("       %-6s %s%n", new Object[]{option.getFlag(), firstLine});
                    }
                    lines.stream().map(highlightKeywords).forEach(s -> out.format("%s%s%n", new Object[]{"       ", s}));
                } else {
                    String flag = (String)highlight.apply(option.getFlag());
                    out.format("%s%s%n", new Object[]{"       ", flag});
                    lines.stream().map(highlightKeywords).forEach(s -> out.format("%s%s%n", new Object[]{"       ", s}));
                }
                if (!iterator.hasNext()) continue;
                out.println();
                continue;
            }
            if (element instanceof Bullet) {
                Bullet bullet = (Bullet)element;
                content = Wrap.wrap(bullet.getContent(), this.column - "       ".length());
                List<String> lines = Stream.of(content.split("\n")).map(s -> String.format("%s%s", "       ", s)).map(highlightKeywords).collect(Collectors.toList());
                String first = ((String)lines.get(0)).substring(1);
                lines.set(0, "o" + first);
                lines.forEach(s -> out.format("%s%s%n", new Object[]{"       ", s}));
                if (!iterator.hasNext()) continue;
                out.println();
                continue;
            }
            if (!(element instanceof Preformatted)) continue;
            Preformatted preformatted = (Preformatted)element;
            Stream.of(preformatted.getContent().split("\n")).forEach(s -> out.format("%s    %s%n", new Object[]{"       ", s}));
            if (!iterator.hasNext()) continue;
            out.println();
        }
        return out.toString();
    }

    public static List<Option> getOptions(Document document) {
        return document.getElements().stream().filter(element -> element instanceof Option).map(Option.class::cast).collect(Collectors.toList());
    }
}

