/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

import java.lang.annotation.Annotation;
import java.util.List;
import org.tomitribe.crest.api.interceptor.CrestContext;
import org.tomitribe.crest.api.interceptor.ParameterMetadata;
import org.tomitribe.crest.api.table.Border;
import org.tomitribe.crest.api.table.Table;
import org.tomitribe.crest.api.table.TableOptions;
import org.tomitribe.util.collect.ObjectMap;

public class Options
implements Table {
    private Boolean header;
    private String fields;
    private String sort;
    private Border border;

    public String getFields() {
        return this.fields;
    }

    public String getSort() {
        return this.sort;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setHeader(Boolean header) {
        this.header = header;
    }

    public Boolean isHeader() {
        return this.header;
    }

    public String fields() {
        return this.fields;
    }

    public boolean header() {
        return this.header;
    }

    public String sort() {
        return this.sort;
    }

    public Border border() {
        return this.border;
    }

    public Class<? extends Annotation> annotationType() {
        return this.getClass();
    }

    public static Options from(Table table) {
        Options options = new Options();
        options.setBorder(table.border());
        options.setFields(table.fields());
        options.setHeader(table.header());
        options.setSort(table.sort());
        return options;
    }

    public Options copy() {
        Options options = new Options();
        options.setBorder(this.border);
        options.setFields(this.fields);
        options.setHeader(this.header);
        options.setSort(this.sort);
        return options;
    }

    public static Options from(TableOptions table) {
        Options options = new Options();
        options.setBorder(table.getBorder());
        options.setFields(table.getFields());
        options.setHeader(table.isHeader());
        options.setSort(table.getSort());
        return options;
    }

    public Options override(Options overrides) {
        Options options = this.copy();
        if (overrides.border() != null) {
            options.setBorder(overrides.border());
        }
        if (overrides.sort() != null) {
            options.setSort(overrides.sort());
        }
        if (overrides.fields() != null) {
            options.setFields(overrides.fields());
        }
        if (overrides.isHeader() != null) {
            options.setHeader(overrides.isHeader());
        }
        return options;
    }

    public static Options from(CrestContext crestContext) {
        Options defaults = Options.from(crestContext.getMethod().getAnnotation(Table.class));
        Options overrides = Options.from(crestContext.getParameterMetadata(), crestContext.getParameters());
        return defaults.override(overrides);
    }

    public static Options from(List<ParameterMetadata> parameterMetadata, List<Object> parameters) {
        Options options = new Options();
        ObjectMap map = new ObjectMap((Object)options);
        for (int i = 0; i < parameterMetadata.size(); ++i) {
            Object value;
            ParameterMetadata metadata = parameterMetadata.get(i);
            if (metadata.getType().equals((Object)ParameterMetadata.ParamType.BEAN_OPTION) && (value = parameters.get(i)) instanceof TableOptions) {
                TableOptions tableOptions = (TableOptions)value;
                Options overrides = Options.from(tableOptions);
                options = options.override(overrides);
            }
            if (!metadata.getType().equals((Object)ParameterMetadata.ParamType.OPTION) || !metadata.getName().startsWith("table-")) continue;
            String key = metadata.getName().replace("table-", "");
            Object value2 = parameters.get(i);
            map.put(key, value2);
        }
        return options;
    }
}

