/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.tomitribe.crest.api.PrintOutput;
import org.tomitribe.crest.api.interceptor.CrestContext;
import org.tomitribe.crest.api.interceptor.CrestInterceptor;
import org.tomitribe.crest.table.Border;
import org.tomitribe.crest.table.Data;
import org.tomitribe.crest.table.Formatting;
import org.tomitribe.crest.table.Options;
import org.tomitribe.crest.table.Table;
import org.tomitribe.crest.term.Screen;

@org.tomitribe.crest.api.table.Table
public class TableInterceptor {
    @CrestInterceptor
    public Object intercept(CrestContext crestContext) {
        Object result = crestContext.proceed();
        Options options = Options.from(crestContext);
        if (result instanceof Iterable) {
            Iterable list = (Iterable)result;
            return new TableOutput(list, options);
        }
        if (result instanceof Stream) {
            Stream stream = (Stream)result;
            List list = stream.collect(Collectors.toList());
            return new TableOutput(list, options);
        }
        if (result != null && result.getClass().isArray()) {
            List<Object> list = Arrays.asList((Object[])result);
            return new TableOutput(list, options);
        }
        return result;
    }

    public static class TableOutput
    implements PrintOutput {
        private final Data data;
        private final Options options;

        public TableOutput(Iterable<?> iterable, Options options) {
            this.data = Formatting.asTable(iterable, options);
            this.options = options;
        }

        public void write(PrintStream out) throws IOException {
            int guess = Screen.guessWidth();
            int width = guess > 0 ? guess : 150;
            Border.Builder builder = this.getBuilder();
            Table table = new Table(this.data, builder.build(), width);
            table.format(out);
        }

        private Border.Builder getBuilder() {
            Border.Builder builder;
            Method method;
            String borderName = this.options.getBorder().name();
            try {
                method = Border.class.getMethod(borderName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Border not found: " + borderName);
            }
            try {
                builder = (Border.Builder)method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to access method Border." + borderName);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Unable to call method Border." + borderName, e);
            }
            return builder;
        }
    }
}

