/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.help;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.tomitribe.crest.api.Command;
import org.tomitribe.crest.api.Option;
import org.tomitribe.crest.help.CommandJavadoc;
import org.tomitribe.crest.help.IllegalElementException;

@AutoService(value=Processor.class)
public class HelpProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(Command.class.getCanonicalName());
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Map<String, List<CommandJavadoc>> all = roundEnv.getElementsAnnotatedWith(Command.class).stream().filter(annotatedElement -> annotatedElement.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).map(this::processCommand).filter(Objects::nonNull).collect(Collectors.groupingBy(CommandJavadoc::getName));
        all.values().forEach(this::writeAll);
        return true;
    }

    private void writeAll(List<CommandJavadoc> list) {
        for (int i = 0; i < list.size(); ++i) {
            CommandJavadoc commandJavadoc = list.get(i);
            this.storeProperties(commandJavadoc.getResourceFileName(i), commandJavadoc.getProperties());
        }
    }

    private CommandJavadoc processCommand(ExecutableElement executableElement) {
        String commandName = this.getCommandName(executableElement);
        String className = executableElement.getEnclosingElement().toString();
        CommandJavadoc commandJavadoc = new CommandJavadoc(className, commandName);
        String javadoc = this.processingEnv.getElementUtils().getDocComment(executableElement);
        if (javadoc != null) {
            commandJavadoc.setJavadoc(javadoc);
        }
        for (VariableElement variableElement : executableElement.getParameters()) {
            Option option = variableElement.getAnnotation(Option.class);
            if (option == null) continue;
            for (String optionName : option.value()) {
                commandJavadoc.getProperties().put(optionName, variableElement.getSimpleName() + "");
            }
        }
        List<String> argNames = executableElement.getParameters().stream().map(Element::getSimpleName).map(Objects::toString).collect(Collectors.toList());
        commandJavadoc.setArgNames(argNames);
        List<String> argTypes = executableElement.getParameters().stream().map(VariableElement.class::cast).map(Element::asType).map(TypeMirror::toString).collect(Collectors.toList());
        commandJavadoc.setArgTypes(argTypes);
        return commandJavadoc;
    }

    private void storeProperties(String resourceFile, Properties properties) {
        try {
            Filer filer = this.processingEnv.getFiler();
            FileObject file = filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceFile, new Element[0]);
            properties.store(file.openOutputStream(), null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getCommandName(ExecutableElement executableElement) {
        Command command = executableElement.getAnnotation(Command.class);
        return Stream.of(command.value(), executableElement.getSimpleName() + "").filter(Objects::nonNull).filter(s -> s.length() > 0).findFirst().orElseThrow(() -> new IllegalElementException("Illegal command with no name", executableElement));
    }
}

