/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tomitribe.crest.api.PrintOutput;
import org.tomitribe.crest.table.Border;
import org.tomitribe.crest.table.Data;
import org.tomitribe.crest.table.Options;
import org.tomitribe.crest.table.Table;
import org.tomitribe.crest.term.Screen;
import org.tomitribe.util.Join;

public class Formatting {
    private Formatting() {
    }

    static Data asTable(Iterable<?> iterable, Options options) {
        String[] sort = Formatting.getSortArray(options);
        Object[] fields = Formatting.getFieldsArray(options);
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        for (Object item : iterable) {
            ObjectMap objectMap = new ObjectMap(item);
            if (fields == null) {
                HashSet<String> keys = new HashSet<String>(objectMap.keySet());
                keys.remove("class");
                fields = keys.toArray(new String[0]);
                Arrays.sort(fields);
            }
            ArrayList<Item> row = new ArrayList<Item>();
            for (String string : fields) {
                row.add(Formatting.resolve(objectMap, string));
            }
            rows.add(row);
        }
        if (sort != null && sort.length > 0) {
            rows.sort(Formatting.compareFields((String[])fields, sort));
        }
        Data.Builder data = Data.builder();
        if (options.header()) {
            data.headings(true);
            data.row((String[])fields);
        }
        for (List list : rows) {
            String[] a = new String[fields.length];
            for (int i = 0; i < a.length; ++i) {
                a[i] = ((Item)list.get(i)).getString();
            }
            data.row(a);
        }
        return data.build();
    }

    private static String[] getSortArray(Options options) {
        String sort = options.getSort();
        String[] sortArray = sort == null || sort.length() == 0 ? null : sort.split("[ ,]+");
        return sortArray;
    }

    private static String[] getFieldsArray(Options options) {
        String fields = options.getFields();
        String[] fieldsArray = fields == null || fields.length() == 0 || "all".equals(fields) ? null : fields.split("[ ,]+");
        return fieldsArray;
    }

    public static Comparator<List<Item>> compareFields(String[] fields, String[] sort) {
        return Formatting.compareFields(Arrays.asList(fields), Arrays.asList(sort));
    }

    public static Comparator<List<Item>> compareFields(List<String> fields, List<String> sort) {
        Comparator<List> comparator = (o1, o2) -> 0;
        for (String field : sort) {
            int i = fields.indexOf(field);
            if (i < 0) continue;
            comparator = comparator.thenComparing(strings -> (Item)strings.get(i));
        }
        return comparator;
    }

    private static Item resolve(ObjectMap map, String field) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(field.split("\\.")));
        if (parts.size() > 1) {
            String part = (String)parts.remove(0);
            Object object = map.get(part);
            if (object == null) {
                return new Item("");
            }
            return Formatting.resolve(new ObjectMap(object), Join.join((String)".", parts));
        }
        Object o = map.get(field);
        return new Item(o);
    }

    public static PrintOutput asPrintStream(String[][] strings) {
        int guess = Screen.guessWidth();
        int width = guess > 0 ? guess : 150;
        Data data = new Data(strings, true);
        Table table = new Table(data, Border.asciiCompact().build(), width);
        return table::format;
    }

    public static class Item
    implements Comparable<Item> {
        private final Comparable object;
        private final String string;

        public Item(Object value) {
            this.object = value instanceof Comparable ? (Comparable)value : null;
            this.string = value != null ? value.toString() : "";
        }

        public String getString() {
            return this.string;
        }

        @Override
        public int compareTo(Item that) {
            if (this.object != null || that.object != null) {
                if (that.object == null) {
                    return 1;
                }
                if (this.object == null) {
                    return -1;
                }
                return this.object.compareTo(that.object);
            }
            return this.string.compareTo(that.string);
        }
    }

    public static class ObjectMap {
        private final org.tomitribe.util.collect.ObjectMap map;
        private final Map<String, String> caseInsensitive;

        public ObjectMap(Object object) {
            this.map = new org.tomitribe.util.collect.ObjectMap(object);
            this.caseInsensitive = ObjectMap.caseInsensitiveMapping(this.map);
        }

        public Object get(String name) {
            Object value = this.map.get((Object)name);
            if (value != null) {
                return value;
            }
            String alternateCaseName = this.caseInsensitive.get(name.toLowerCase());
            if (alternateCaseName == null) {
                return null;
            }
            return this.map.get((Object)alternateCaseName);
        }

        public Set<String> keySet() {
            return this.map.keySet();
        }

        private static Map<String, String> caseInsensitiveMapping(org.tomitribe.util.collect.ObjectMap map) {
            HashMap<String, String> fieldMappings = new HashMap<String, String>();
            for (String field : map.keySet()) {
                fieldMappings.put(field.toLowerCase(), field);
            }
            return fieldMappings;
        }
    }
}

