/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.tomitribe.crest.help;

import javax.lang.model.element.ExecutableElement;

public class IllegalElementException extends RuntimeException {
    public IllegalElementException(final String s, final ExecutableElement executableElement) {
        this(s, executableElement, null);
    }

    public IllegalElementException(final String s, final ExecutableElement executableElement, final Throwable t) {
        super(String.format("%s: class %s, method %s",
                s,
                executableElement.getEnclosingElement(),
                executableElement.getSimpleName()
        ), t);
    }
}
